/***************************************************************************
    smb4ksharesiconviewitem  -  The items for Smb4K's shares icon view.
                             -------------------
    begin                : Di Dez 5 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qpixmap.h>

// KDE includes
#include <kiconeffect.h>
#include <kdebug.h>

// application specific includes
#include "smb4ksharesiconviewitem.h"
#include "smb4ksharesiconview.h"

Smb4KSharesIconViewItem::Smb4KSharesIconViewItem( Smb4KShare *share, bool mountpoint,
                                                  Smb4KSharesIconView *parent )
: KIconViewItem( parent, QString::null ), m_share( *share ), m_mountpoint( mountpoint ),
  m_initial_setup( false )
{
  setDropEnabled( true );
  setDragEnabled( true );

  m_loader = new KIconLoader();

  setupItem( m_share, m_mountpoint );
}


Smb4KSharesIconViewItem::~Smb4KSharesIconViewItem()
{
  // Do not touch the Smb4KShare object!
  delete m_loader;
}


void Smb4KSharesIconViewItem::paintItem( QPainter *p, const QColorGroup &cg )
{
  // Set the color of the item text:
  QColorGroup colorgrp( cg );

  if ( m_share.isForeign() )
  {
    colorgrp.setColor( QColorGroup::Text, Qt::gray );
  }

  QIconViewItem::paintItem( p, colorgrp );
}


bool Smb4KSharesIconViewItem::acceptDrop( const QMimeSource *source ) const
{
  if ( source->provides( "text/plain" ) )
  {
    return true;
  }

  return false;
}


void Smb4KSharesIconViewItem::setupItem( const Smb4KShare &share, bool mountpoint )
{
  // Only do something here if either the item hasn't been set up
  // yet, or share and mountpoint changed, respectively.
  if ( !m_initial_setup || !m_share.equals( share ) || m_mountpoint != mountpoint )
  {
    if ( !m_initial_setup || m_share.isBroken() != share.isBroken() )
    {
      int icon_state = m_share.isForeign() ? KIcon::DisabledState : KIcon::DefaultState;

      if ( m_share.isBroken() )
      {
        QImage over = m_loader->loadIcon( "button_cancel", KIcon::Desktop,
                                          0, icon_state, 0L, false ).convertToImage();
        QImage src = m_loader->loadIcon( "hdd_mount", KIcon::Desktop,
                                         0, icon_state, 0L, false ).convertToImage();

        KIconEffect e;
        e.semiTransparent( over );
        e.overlay( src, over );

        m_pixmap = QPixmap( src );
      }
      else
      {
        m_pixmap = m_loader->loadIcon( "hdd_mount", KIcon::Desktop,
                                       0, icon_state, 0L, false );
      }

      setPixmap( m_pixmap );
    }
    else
    {
      // Do nothing
    }

    if ( !m_initial_setup || m_mountpoint != mountpoint )
    {
      setText( (m_mountpoint ? m_share.path() : m_share.name()) );
    }
    else
    {
      // Do nothing
    }

    m_initial_setup = true;
    m_share = share;
    m_mountpoint = mountpoint;
  }
  else
  {
    // Do nothing
  }
}


bool Smb4KSharesIconViewItem::sameShareObject( Smb4KShare *share )
{
  return m_share.equals( *share );
}


void Smb4KSharesIconViewItem::replaceShareObject( Smb4KShare *share )
{
  setupItem( *share, m_mountpoint );
}
