/***************************************************************************
    smb4kprintdialog  -  The print dialog for Smb4K
                             -------------------
    begin                : So Apr 11 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlabel.h>
#include <qlayout.h>
#include <qframe.h>

// KDE includes
#include <klocale.h>
#include <kmessagebox.h>
#include <kurlrequester.h>
#include <knuminput.h>
#include <kdebug.h>

// application specific includes
#include "smb4kprintdialog.h"
#include "../core/smb4kprintinfo.h"
#include "../core/smb4kcore.h"
#include "../core/smb4knetworkitems.h"


Smb4KPrintDialog::Smb4KPrintDialog( Smb4KShareItem *item, QWidget *parent, const char *name )
: KDialogBase( Plain, i18n( "Print File" ), Details|Filler|User1|Cancel, User1, parent, name, true, true ),
m_item( item ), m_ip( QString::null ) /* will collect it in an instant */
{
  setWFlags( Qt::WDestructiveClose );

  if ( !m_item )
  {
    close();
  }

  setButtonGuiItem( User1, KStdGuiItem::print() );
  setButtonText( Details, i18n( "Options" ) );

  // Get the IP address
  if ( Smb4KHostItem *host = Smb4KCore::scanner()->getHost( m_item->host(), m_item->workgroup() ) )
  {
    m_ip = host->ip();
  }

  // Bild the view:
  QFrame *frame = plainPage();

  QGridLayout *layout = new QGridLayout( frame );
  layout->setSpacing( 10 );

  QGroupBox *p = new QGroupBox( 2, Qt::Horizontal, i18n( "Printer" ), frame );
  p->setInsideSpacing( 5 );

  (void) new QLabel( i18n( "Name:" ), p );
  (void) new QLabel( m_item->name()+
                     (!m_item->comment().stripWhiteSpace().isEmpty() ?
                     " ("+m_item->comment()+")" :
                     ""), p );

//   (void) new QLabel( i18n( "Comment:" ), p );
//   (void) new QLabel( m_item->comment(), p );

  (void) new QLabel( i18n( "Host:" ), p );
  (void) new QLabel( m_item->host(), p );

  (void) new QLabel( i18n( "IP address:" ), p );
  (void) new QLabel( m_ip.stripWhiteSpace().isEmpty() ?
                     i18n( "Unknown" ) :
                     m_ip,
                     p );

  (void) new QLabel( i18n( "Workgroup:" ), p );
  (void) new QLabel( m_item->workgroup(), p );

  QGroupBox *f = new QGroupBox( 2, Qt::Horizontal, i18n( "File" ), frame );
  f->setInsideSpacing( 5 );

  (void) new QLabel( i18n( "File:" ), f );
  KURLRequester *requester = new KURLRequester( QString::null, f, "URL" );
  requester->setMode( KFile::File | KFile::LocalOnly );

  QGroupBox *s = new QGroupBox( 2, Qt::Horizontal, i18n( "Options" ), frame );
  s->setInsideSpacing( 5 );

  setDetailsWidget( s );

  (void) new QLabel( i18n( "Copies:" ), s );
  KIntNumInput *cp = new KIntNumInput( 1, s, 10, "Copies" );
  cp->setMinValue( 1 );

  layout->addWidget( p, 0, 0, 0 );
  layout->addWidget( f, 1, 0, 0 );

  setFixedSize( (sizeHint().width() > 350 ? sizeHint().width() : 350), sizeHint().height() );

  enableButton( User1, false );

  connect( requester, SIGNAL( textChanged( const QString & ) ),
           this,      SLOT( slotInputValueChanged( const QString & ) ) );
}


Smb4KPrintDialog::~ Smb4KPrintDialog()
{
  // Do not delete the pointer to the Smb4KShareObject here!
}


/////////////////////////////////////////////////////////////////////////////
//  SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KPrintDialog::slotUser1()
{
  KURLRequester *url = static_cast<KURLRequester *>( child( "URL", "KURLRequester", true ) );
  KIntNumInput *copies = static_cast<KIntNumInput *>( child( "Copies", "KIntNumInput", true ) );

  if ( url && copies )
  {
    if ( !url->url().stripWhiteSpace().isEmpty() )
    {
      if ( Smb4KCore::print()->print( new Smb4KPrintInfo( m_item, m_ip, url->url().stripWhiteSpace(), copies->value() ) ) )
      {
        enableButton( User1, false );

        connect( Smb4KCore::print(), SIGNAL( state( int ) ), this, SLOT( slotPrintStateChanged( int ) ) );
      }
      else
      {
        // FIXME: Should we report an error here?
      }
    }
    else
    {
      KMessageBox::error( this, i18n( "You haven't specified a file." ) );
    }
  }
}


void Smb4KPrintDialog::slotCancel()
{
  if ( Smb4KCore::printIsRunning() )
  {
    Smb4KCore::print()->abort();
  }

  KDialogBase::slotCancel();
}


void Smb4KPrintDialog::slotPrintStateChanged( int state )
{
  switch ( state )
  {
    case PRINT_STOP:
    {
      accept();

      break;
    }
    default:
    {
      break;
    }
  }
}


void Smb4KPrintDialog::slotInputValueChanged( const QString &text )
{
  enableButton( User1, !text.isEmpty() );
}


#include "smb4kprintdialog.moc"
