/***************************************************************************
    smb4kpreviewdialog.h  -  The preview dialog of Smb4K
                             -------------------
    begin                : Fre Jul 4 2003
    copyright            : (C) 2003-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPREVIEWDIALOG_H
#define SMB4KPREVIEWDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qvaluelist.h>

// KDE includes
#include <kdialogbase.h>
#include <kiconview.h>
#include <ktoolbar.h>
#include <kcombobox.h>

// application specific includes
#include "../core/smb4kpreviewitem.h"

// forward declarations
class Smb4KShareItem;

/**
 * This is the preview dialog of Smb4K. You can preview remote
 * shares with it.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KPreviewDialog : public KDialogBase
{
  Q_OBJECT

  public:
    /**
     * This is the constructor of the preview dialog.
     *
     * @param item          The Smb4KShareItem object.
     *
     * @param parent        The parent of this widget
     *
     * @param name          The name of this widget
     */
    Smb4KPreviewDialog( Smb4KShareItem *item, QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KPreviewDialog();

    /**
     * This function returns TRUE if the preview dialog has been
     * initialized correctly and FALSE otherwise.
     *
     * @returns TRUE if the dialog was initialized correctly.
     */
    bool isInitialized() { return m_initialized; }

  protected slots:
    /**
     * This slot receives the results of the attempt to generate
     * a preview.
     *
     * @param item          The Smb4KPreviewItem for which a preview
     *                      was generated.
     */
    void slotReceivedData( Smb4KPreviewItem *item );

    /**
     * Is called, if one icon view item is clicked.
     */
    void slotItemExecuted( QIconViewItem *item );

    /**
     * Is called, if a tool bar button is clicked.
     */
    void slotButtonClicked( int id );

    /**
     * Is called, if an item in the combo box is activated.
     */
    void slotItemActivated( const QString &item );

    /**
     * Reimplemented from KDialogBase. Saves the dialog size and
     * then executes KDialogBase::slotClose().
     */
    void slotClose();

  private:
    /**
     * Enumeration for the buttons.
     */
    enum ButtonID{ Reload, Up, Back, Forward, Combo, None };

    /**
     * The current button id
     */
    int m_button_id;

    /**
     * Sets up the file view.
     */
    void setupView();

    /**
     * The icon view.
     */
    KIconView *m_view;

    /**
     * The toolbar.
     */
    KToolBar *m_toolbar;

    /**
     * The combo box.
     */
    KComboBox *m_combo;

    /**
     * The private Smb4KHostItem object
     */
    Smb4KPreviewItem *m_item;

    /**
     * This list holds the history of the session.
     */
    QStringList m_history;

    /**
     * This iterator points to the current item in the history.
     */
    QStringList::Iterator m_current_item;

    /**
     * TRUE if the dialog was successfully initilized and
     * FALSE otherwise.
     */
    bool m_initialized;
};
#endif
