/***************************************************************************
    smb4kmountdialog  -  This class provides a dialog for mounting shares
    manually.
                             -------------------
    begin                : Mo Nov 29 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>

// KDE includes
#include <klocale.h>
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
#include "smb4kmountdialog.h"

#include "../core/smb4kmounter.h"
#include "../core/smb4kbookmarkhandler.h"
#include "../core/smb4kbookmark.h"
#include "../core/smb4kcore.h"
#include "../smb4k.h"

Smb4KMountDialog::Smb4KMountDialog( QWidget *parent, const char *name ) :
KDialogBase( Plain, i18n( "Mount Share" ), Ok|Cancel, Ok, parent, name, true, true )
{
  setWFlags( Qt::WDestructiveClose );

  setupView();

  setFixedSize( (sizeHint().width() > 350 ? sizeHint().width() : 350), sizeHint().height() );
}


Smb4KMountDialog::~Smb4KMountDialog()
{
}


void Smb4KMountDialog::setupView()
{
  QFrame *frame = plainPage();
  QGridLayout *layout = new QGridLayout( frame );
  layout->setSpacing( 5 );
  layout->setMargin( 0 );

  QLabel *shareLabel = new QLabel( i18n( "Share:" ), frame );
  m_share_input = new KLineEdit( frame, "ShareInputLine" );
  m_share_input->setMinimumWidth( 200 );
  m_share_input->setFocus();

  QLabel *addressLabel = new QLabel( i18n( "IP Address:" ), frame );
  m_ip_input = new KLineEdit( frame, "IPInputLine" );
  m_ip_input->setMinimumWidth( 200 );

  QLabel *workgroupLabel = new QLabel( i18n( "Workgroup:" ), frame );
  m_workgroup_input = new KLineEdit( frame, "WorkgroupInputLine" );
  m_workgroup_input->setMinimumWidth( 200 );

  m_bookmark = new QCheckBox( i18n( "Add this share to the bookmarks" ), frame, "BookmarkButton" );

  layout->addWidget( shareLabel, 0, 0, 0 );
  layout->addWidget( m_share_input, 0, 1, 0 );
  layout->addWidget( addressLabel, 1, 0, 0 );
  layout->addWidget( m_ip_input, 1, 1, 0 );
  layout->addWidget( workgroupLabel, 2, 0, 0 );
  layout->addWidget( m_workgroup_input, 2, 1, 0 );
  layout->addMultiCellWidget( m_bookmark, 3, 3, 0, 1, 0 );

  connect( m_share_input, SIGNAL( textChanged ( const QString & ) ) ,
           this,          SLOT( slotChangeInputValue( const QString & ) ) );

  slotChangeInputValue( m_share_input->text() );
}


/////////////////////////////////////////////////////////////////////////////
//  SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KMountDialog::slotChangeInputValue( const QString& _test)
{
  enableButtonOK( !_test.isEmpty() );
}

void Smb4KMountDialog::slotOk()
{
  // FIXME: Leave the decision if the share is not formatted
  // correctly up to the mounter. Just pass the string to
  // Smb4KCore::mounter()->mountShare().

  if ( !m_share_input->text().stripWhiteSpace().isEmpty() )
  {
#ifndef __FreeBSD__
    if ( m_share_input->text().contains( "/" ) == 3 )
#else
    if ( m_share_input->text().contains( "/" ) == 3
         && m_share_input->text().contains( '@' ) == 0 )
#endif
    {
      QString host = m_share_input->text().stripWhiteSpace().section( "/", 2, 2 );
      QString share = m_share_input->text().stripWhiteSpace().section( "/", 3, 3 );
      QString ip = m_ip_input->text().stripWhiteSpace();
      QString workgroup = m_workgroup_input->text().stripWhiteSpace();

      Smb4KCore::mounter()->mountShare( workgroup, host, ip, share );

      if ( m_bookmark->isChecked() )
      {
        Smb4KCore::bookmarkHandler()->addBookmark( new Smb4KBookmark( host, share, workgroup, ip, QString::null ) );
      }

      connect( Smb4KCore::mounter(), SIGNAL( state( int ) ), this, SLOT( slotMounterStateChanged( int ) ) );
    }
    else
    {
      KMessageBox::error( this, i18n( "The format of the share you entered is not correct. It must have the form //HOST/SHARE." ) );
    }
  }
}


void Smb4KMountDialog::slotCancel()
{
  Smb4KCore::mounter()->abort();

  KDialogBase::slotCancel();
}


void Smb4KMountDialog::slotMounterStateChanged( int state )
{
  switch ( state )
  {
    case MOUNTER_STOP:
    {
      accept();

      break;
    }
    default:
    {
      break;
    }
  }
}

#include "smb4kmountdialog.moc"

