/***************************************************************************
    smb4kbookmarkeditor  -  description
                             -------------------
    begin                : Di Okt 5 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KBOOKMARKEDITOR_H
#define SMB4KBOOKMARKEDITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kdialogbase.h>
#include <klistview.h>
#include <kactioncollection.h>

/**
 * This is the bookmark editor of Smb4K.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KBookmarkEditor : public KDialogBase
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param parent  The parent of this dialog.
     *
     * @param name    The name of this dialog.
     */
    Smb4KBookmarkEditor( QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KBookmarkEditor();

    /**
     * This function returns a pointer to the action collection of this class.
     * You should use it to include the action into the action collection of the
     * main action collection (e.g. KMainWindow::actionCollection()).
     *
     * The entries in this action collection are members of the group "BookmarkEditor".
     *
     * @returns       a pointer to the action collection of this class
     */
    KActionCollection *action_collection() { return m_collection; }

  protected slots:
    /**
     * This slot is activated whenever the right mouse button
     * has been pressed.
     *
     * @param item    The item over which the mouse pointer is (maybe NULL).
     *
     * @param pos     The position where the mouse is.
     *
     * @param col     The column of the list view item.
     */
    void slotRightButtonPressed ( QListViewItem *item, const QPoint &pos, int col );

    /**
     * This slot is activated whenever the remove button of the
     * menu is clicked.
     */
    void slotRemoveClicked();

    /**
     * This slot is activated whenever the 'Remove All' button of
     * the menu has been clicked.
     */
    void slotDeleteAllClicked();

    /**
     * This slot is activated if the OK button has been clicked.
     */
    void slotOkClicked();

    /**
     * This slot is activated if the Cancel button has been clicked.
     */
    void slotCancelClicked();

    /**
     * This slot is invoked, if the bookmark handler updated the bookmarks.
     */
    void slotLoadBookmarks();

    /**
     * This slot is invoked when an item was renamed. It will adjust the columns.
     *
     * @param item    The item that was renamed.
     */
    void slotItemRenamed( QListViewItem *item );

  private:
    /**
     * Enumeration for the columns in the list view.
     */
    enum Columns { Bookmark = 0, Workgroup = 1, IPAddress = 2, Label = 3 };
    /**
     * The listview.
     */
    KListView *m_view;

    /**
     * The action collection of this class.
     */
    KActionCollection *m_collection;
};

#endif
