/***************************************************************************
                          smb4kprintinfo  -  description
                             -------------------
    begin                : Mo Apr 19 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPRINTINFO_H
#define SMB4KPRINTINFO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qstring.h>

// application specific includes
#include "smb4knetworkitems.h"

/**
 * This class provides a container that holds all the info
 * that is needed to print a file.
 */

class Smb4KPrintInfo
{
  public:
    /**
     * The constructor.
     *
     * @param item          The Smb4KShareItem that represents the printer
     *
     * @param ip            The IP address of the host
     *
     * @param filepath      The path of the file to print
     *
     * @param copies        The number of copies
     */
    Smb4KPrintInfo( Smb4KShareItem *item, const QString &ip, const QString &filepath = QString::null, int copies = 1 );
    /**
     * Empty constructor.
     */
    Smb4KPrintInfo() {}
    /**
     * The destructor.
     */
    ~Smb4KPrintInfo();
    /**
     * Returns the path of the file.
     */
    const QString &path() const { return m_path; }
    /**
     * Returns the host where the printer is located.
     */
    const QString &host() const { return m_host; }
    /**
     * Returns the workgroup in which the host located.
     */
    const QString &workgroup() const { return m_workgroup; }
    /**
     * Returns the name of the printer.
     */
    const QString &printer() const { return m_printer; }
    /**
     * Returns the IP address of the host.
     */
    const QString &ip() const { return m_ip; }
    /**
     * Sets the path to the file to print.
     */
    void setPath( const QString &path );
    /**
     * Returns the number of copies the user wants to have.
     */
    int copies() const { return m_copies; }
    /**
     * Sets the number of copies.
     */
    void setCopies( int num );
    /**
     * Returns the comment.
     */
    const QString &comment() const { return m_comment; }

  private:
    /**
     * The workgroup.
     */
    QString m_workgroup;
    /**
     * The host.
     */
    QString m_host;
    /**
     * The IP address.
     */
    QString m_ip;
    /**
     * The printer name.
     */
    QString m_printer;
    /**
     * The path to the file to print.
     */
    QString m_path;
    /**
     * Holds the number of copies the user wants to have.
     */
    int m_copies;
    /**
     * The comment
     */
    QString m_comment;

    /**
     * This function checks if the IP address is valid, i.e. the
     * IP address is either IP v4 or IP v6. It returns either TRUE
     * or FALSE.
     *
     * @param ip            The IP address that's going to be checked.
     *
     * @returns TRUE if the IP address is valid and FALSE otherwise.
     */
    bool ipIsValid( const QString &ip );
};

#endif

