/***************************************************************************
                          smb4kprintinfo  -  description
                             -------------------
    begin                : Mo Apr 19 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <ksocketaddress.h>

// application specific includes
#include "smb4kprintinfo.h"


Smb4KPrintInfo::Smb4KPrintInfo( Smb4KShareItem *item, const QString &ip, const QString &path, int copies )
: m_workgroup( item->workgroup() ), m_host( item->host() ), m_printer( item->name() ), m_path( path ),
  m_copies( copies ), m_comment( item->comment() )
{
  m_ip = ipIsValid( ip ) ? ip : QString::null;
}


Smb4KPrintInfo::~Smb4KPrintInfo()
{
}


void Smb4KPrintInfo::setPath( const QString &path )
{
  m_path = path;
}


void Smb4KPrintInfo::setCopies( int num )
{
  m_copies = num;
}


bool Smb4KPrintInfo::ipIsValid( const QString &ip )
{
  if ( !ip.isEmpty() )
  {
    KNetwork::KIpAddress ip_address = KNetwork::KIpAddress( ip );

    if ( !ip_address.isIPv4Addr() && !ip_address.isIPv6Addr() )
    {
      return false;
    }
  }
  else
  {
    return false;
  }

  return true;
}

