/***************************************************************************
    smb4kprint  -  The printing core class.
                             -------------------
    begin                : Tue Mar 30 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPRINT_H
#define SMB4KPRINT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qstring.h>
#include <qwidget.h>

// KDE includes
#include <kprocess.h>
#include <kdialogbase.h>

// forward declarations
class Smb4KPrintInfo;


/**
 * This is a core class. It provides the interface for printing documents over
 * the network neighborhood.
 *
 * You shouldn't use this class directly but access it through Smb4KCore.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KPrint : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     */
    Smb4KPrint( QObject *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KPrint();

    /**
     * This function starts the printing of a file. It takes a Smb4KPrintInfo object
     * and constructs the print dialog from it. The information entered there will be
     * used to print the file.
     *
     * Note that @p info will be deleted. So do not try to use the pointer later in your
     * code!
     *
     * @param info        The Smb4KShareItem object
     */
    bool print( Smb4KPrintInfo *info );

    /**
     * Aborts the print process.
     */
    void abort();

    /**
     * This function returns TRUE if the printer handler is running and
     * FALSE otherwise.
     *
     * @returns           TRUE is the printer handler is running and FALSE otherwise.
     */
    bool isRunning() { return m_working; }

  signals:
    /**
     * This signal emits the run state.
     *
     * @param state       The so-called run state. There are several defined
     *                    in the smb4kdefs.h header file.
     */
    void state( int state );

  protected slots:
    /**
     * This slot receives output at stdout.
     */
    void slotReceivedStdout( KProcess *, char *buf, int len );

    /**
     * This slot receives output at stderr.
     */
    void slotReceivedStderr( KProcess *, char *buf, int len );

    /**
     * This slot is called when the process exited.
     */
    void slotProcessExited( KProcess * );

    /**
     * This slot is invoked if the print process should be restarted
     * (i.e. because authentication data was missing, etc.).
     */
    void slotRetry();

  private:

    /**
     * The KProcess object.
     */
    KProcess *m_proc;

    /**
     * The buffer
     */
    QString m_buffer;

    /**
     * This boolean is TRUE if the printer handler is running and
     * FALSE otherwise.
     */
    bool m_working;

    /**
     * The print info object
     */
    Smb4KPrintInfo *m_info;

    /**
     * Sets the device URI
     */
    void setDeviceURI();

    /**
     * Do normal printing.
     */
    void printNormal();

    /**
     * Print DVI files.
     */
    void printDVI();

    /**
     * Print text files
     */
    void printText();
};

#endif
