/***************************************************************************
    smb4khomesshareshandler  -  This class handles the homes shares.
                             -------------------
    begin                : Do Aug 10 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KHOMESSHARESHANDLER_H
#define SMB4KHOMESSHARESHANDLER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>

// KDE includes
#include <kdialogbase.h>
#include <kconfig.h>


/**
 * This class belongs to the core of Smb4K and takes care of the
 * user names that are/were defined for a certain 'homes' share.
 *
 * @author Alexander Reinholdt <dustpuppy@mail.berlios.de>
 */

class Smb4KHomesSharesHandler : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor
     *
     * @param parent            The parent object of this class
     *
     * @param name              The name of this class
     */
    Smb4KHomesSharesHandler( QObject *parent = 0, const char *name = 0 );

    /**
     * The destructor
     */
    ~Smb4KHomesSharesHandler();

    /**
     * This function will open a dialog where the user has to define a
     * user name to access a 'homes' share. Besides returning this name,
     * this function will also store the name in the configuration file.
     *
     * @param host        The host where the homes share is located
     *
     * @param parent      The parent widget
     *
     * @param name        The name of this dialog
     *
     * @returns           A user name
     */
    const QString specifyUser( const QString &host, QWidget *parent = 0, const char *name = 0 );

    /**
     * Read and return the user names that are defined for a homes share.
     *
     * @param host        The name of the host where the 'homes' share is located.
     *
     * @returns           the list of user names for this homes share.
     */
    const QStringList &homesUsers( const QString &host ) { return read_names( host ); }

  protected slots:
    /**
     * Is connected to the textChanged() signal of the combo box
     * in the "Specify User" dialog.
     *
     * @param text        The text in the combo box
     */
    void slotTextChanged( const QString &text );

    /**
     * This slot is called if the User1 button, i.e. the "Clear" button
     * in the "Specify User" dialog has been clicked. It removes all
     * entries from the combo box.
     */
    void slotClearClicked();

  private:
    /**
     * Read the user names for a homes share.
     *
     * @param host              The host where the homes share is located.
     */
    const QStringList &read_names( const QString &host );

    /**
     * Write the user names for a certain homes share to the config
     * file.
     *
     * @param host              The host where the homes share is located
     *
     * @param names             The list of user names that are defined for
     *                          the homes share and should be written to the
     *                          config file.
     */
    void write_names( const QString &host, const QStringList &names );

    /**
     * This is the dialog that's shown the user when he/she has to
     * provide a user name.
     */
    KDialogBase *m_dlg;

    /**
     * This is a buffer for the list of names defined for a 'homes' share.
     */
    QStringList m_names;
};

#endif
