/***************************************************************************
    smb4kglobal_p  -  This is the private helper class of the Smb4KGlobal
    namespace.
                             -------------------
    begin                : Di Jul 24 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KGLOBAL_P_H
#define SMB4KGLOBAL_P_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qtimer.h>

// KDE includes
#include <kconfig.h>

// application specific includes
#include "smb4kpasswordhandler.h"
#include "smb4ksambaoptionshandler.h"
#include "smb4khomesshareshandler.h"

/**
 * This class is a private helper for the Smb4KGlobal namespace.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KGlobalPrivate
{
  public:
    /**
     * Constructor
     */
    Smb4KGlobalPrivate();

    /**
     * Destructor
     */
    ~Smb4KGlobalPrivate();

    /**
     * Returns a pointer to the global timer
     */
    QTimer *timer();

    /**
     * Returns the handler for homes shares
     */
    Smb4KHomesSharesHandler *homesHandler();

    /**
     * Returns a pointer to the global password handler object
     */
    Smb4KPasswordHandler *passwordHandler();

    /**
     * Returns a pointer to the global Samba options handler
     */
    Smb4KSambaOptionsHandler *optionsHandler();

    /**
     * Returns the name of the temporary directory.
     */
    const QString &tempDir();

    /**
     * Return the user names defined for a certain homes share
     */
    const QStringList homesUsers( const QString &host );

  private:
    QTimer *m_timer;
    Smb4KPasswordHandler *m_passwd_handler;
    Smb4KSambaOptionsHandler *m_options_handler;
    Smb4KHomesSharesHandler *m_homes_handler;
    QString m_temp_dir;
};

#endif
