/***************************************************************************
    smb4kglobal_p  -  This is the private helper class of the Smb4KGlobal
    namespace.
                             -------------------
    begin                : Di Jul 24 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// system includes
#include <errno.h>
#include <stdlib.h>

// application specific includes
#include "smb4kglobal_p.h"
#include "smb4kdefs.h"
#include "smb4kerror.h"


Smb4KGlobalPrivate::Smb4KGlobalPrivate()
{
  m_timer = new QTimer();
  m_timer->start( TIMER_INTERVAL, false );

  // Do NOT initialize these classes here; you'll
  // get crashes.
  m_passwd_handler = NULL;
  m_options_handler = NULL;
  m_homes_handler = NULL;

  m_temp_dir = QString::null;
}


Smb4KGlobalPrivate::~Smb4KGlobalPrivate()
{
  rmdir( m_temp_dir.local8Bit() );

  delete m_timer;
  delete m_passwd_handler;
  delete m_options_handler;
  delete m_homes_handler;
}


QTimer *Smb4KGlobalPrivate::timer()
{
  return m_timer;
}


Smb4KHomesSharesHandler *Smb4KGlobalPrivate::homesHandler()
{
  return m_homes_handler ? m_homes_handler :
                          (m_homes_handler = new Smb4KHomesSharesHandler());
}


Smb4KPasswordHandler *Smb4KGlobalPrivate::passwordHandler()
{
#ifndef __FreeBSD__
  return m_passwd_handler ? m_passwd_handler :
                            (m_passwd_handler = new Smb4KPasswordHandler( homesHandler() ));
#else
  return m_passwd_handler ? m_passwd_handler :
                            (m_passwd_handler = new Smb4KPasswordHandler( homesHandler(), optionsHandler() ));
#endif
}


Smb4KSambaOptionsHandler *Smb4KGlobalPrivate::optionsHandler()
{
  return m_options_handler ? m_options_handler :
                             (m_options_handler = new Smb4KSambaOptionsHandler());
}


const QString &Smb4KGlobalPrivate::tempDir()
{
  if ( m_temp_dir.isEmpty() )
  {
    char tmpd_name[] = "/tmp/smb4k.XXXXXX";

    if ( mkdtemp( tmpd_name ) == NULL )
    {
      Smb4KError::error( ERROR_CREATING_TEMP_DIR, tmpd_name, strerror( errno ) );

      return QString::null;
    }

    m_temp_dir = QString( tmpd_name );
  }

  return m_temp_dir;
}


const QStringList Smb4KGlobalPrivate::homesUsers( const QString &host )
{
  if ( !m_homes_handler )
  {
    m_homes_handler = new Smb4KHomesSharesHandler();
  }

  return m_homes_handler->homesUsers( host );
}
