/***************************************************************************
    smb4kerror  -  This is the class that manages the error messages.
                             -------------------
    begin                : Fr Sep 22 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "smb4kerror.h"
#include "smb4kdefs.h"

void Smb4KError::error( int code, const QString &text, const QString &details )
{
  switch ( code )
  {
    case ERROR_GETTING_BROWSELIST:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The browse list could not be retrieved.\nDetailed information cannot be provided because there was no error message." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The browse list could not be retrieved.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
    case ERROR_GETTING_MEMBERS:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The list of servers could not be retrieved.\nDetailed information cannot be provided because there was no error message." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The list of servers could not be retrieved.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
    case ERROR_GETTING_SHARES:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The list of shares could not be retrieved.\nDetailed information cannot be provided because there was no error message." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The list of shares could not be retrieved.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
    case ERROR_GETTING_PREVIEW:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The preview could not be compiled.\nDetailed information cannot be provided because there was no error message." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The preview could not be compiled.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
    case ERROR_OPENING_WALLET_FAILED:
    {
      KMessageBox::error( 0, i18n( "The wallet \"%1\" could not be opened. KWallet support will be disabled for this session." ).arg( text ) );

      break;
    }
    case ERROR_GETTING_PERMISSIONS:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "Some file permissions could not be determined.\nDetailed information cannot be provided because there was no error message." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "Some file permissions could not be determined.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
    case ERROR_UNMOUNTING_NOT_ALLOWED:
    {
      KMessageBox::error( 0, i18n( "You are not allowed to unmount this share, because it is owned by another user." ) );

      break;
    }
    case ERROR_MOUNTING_SHARE:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The share \"%1\" could not be mounted.\nDetailed information cannot be provided because there was no error message." ).arg( text ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The share \"%1\" could not be mounted.\nRead the error message under \"Details\" to find out more." ).arg( text ), details );
      }

      break;
    }
    case ERROR_UNMOUNTING_SHARE:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The share \"%1\" could not be unmounted.\nDetailed information cannot be provided because there was no error message." ).arg( text ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The share \"%1\" could not be unmounted.\nRead the error message under \"Details\" to find out more." ).arg( text ), details );
      }

      break;
    }
    case ERROR_FILE_NOT_FOUND:
    {
      KMessageBox::error( 0, i18n( "The file \"%1\" could not be found." ).arg( text ) );

      break;
    }
    case ERROR_READING_FILE:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The file \"%1\" could not be read." ).arg( text ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The file \"%1\" could not be read.\nRead the error message under \"Details\" to find out more." ).arg( text ), details );
      }

      break;
    }
    case ERROR_GETTING_HOSTNAME:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The name of your computer could not be determined by using the gethostname() system call.\nDetailed information cannot be provided because there was no error message." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The name of your computer could not be determined by using the gethostname() system call.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
    case ERROR_MISSING_PROGRAMS:
    {
      KMessageBox::error( 0, i18n( "Either your PATH environment variable is not set properly or there are the following programs missing on your system:\n%1\nPlease correct this and restart Smb4K." ).arg( text ) );

      break;
    }
    case ERROR_LOCKED:
    {
      KMessageBox::error( 0, i18n( "The file \"%1\" is currently being edited by user %2. To avoid any problems, access to this file is denied at the moment. Please try again later." ).arg( text.section( ":", 1, 1 ), text.section( ":", 0, 0 ) ) );

      break;
    }
    case ERROR_MKDIR_FAILED:
    {
      KMessageBox::error( 0, i18n( "The directory \"%1\" could not be created." ).arg( text ) );

      break;
    }
    case ERROR_WRITING_FILE:
    {
      KMessageBox::error( 0, i18n( "The file \"%1\" could not be written." ).arg( text ) );

      break;
    }
    case ERROR_MOUNTPOINT_EMPTY:
    {
      KMessageBox::error( 0, i18n( "The share could not be unmounted, because the mount point string was empty." ) );

      break;
    }
    case ERROR_FEATURE_NOT_ENABLED:
    {
      KMessageBox::error( 0, i18n( "This feature has not been enabled." ) );

      break;
    }
    case ERROR_BOOKMARK_PRINTER:
    {
      KMessageBox::error( 0, i18n( "Printers cannot be bookmarked." ) );

      break;
    }
    case ERROR_IP_CANNOT_BE_USED:
    {
      KMessageBox::sorry( 0, i18n( "IP addresses are not supported with this search method. Please choose \"Use nmblookup\" in the configuration dialog and try again." ) );

      break;
    }
    case ERROR_IMPORTING_SHARES:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The list of mounted SMBFS and CIFS shares could not be imported.\nDetailed information cannot be provided because there was no error message." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The list of mounted SMBFS and CIFS shares could not be imported.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
    case ERROR_COMMAND_NOT_FOUND:
    {
      KMessageBox::error( 0, i18n( "The command \"%1\" could not be found." ).arg( text ) );

      break;
    }
    case ERROR_PRINTING:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The file \"%1\" could not be printed.\nDetailed information cannot be provided because there was no error message." ).arg( text ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The file \"%1\" could not be printed.\nRead the error message under \"Details\" to find out more." ).arg( text ), details );
      }

      break;
    }
    case ERROR_CREATING_TEMP_DIR:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The temporary directory \"%1\" could not be created.\nDetailed information cannot be provided because there was no error message." ).arg( text ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The temporary directory \"%1\" could not be created.\nRead the error message under \"Details\" to find out more." ).arg( text ), details );
      }

      break;
    }
    case ERROR_CREATING_TEMP_FILE:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The temporary file \"%1\" could not be created.\nDetailed information cannot be provided because there was no error message." ).arg( text ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The temporary file \"%1\" could not be created.\nRead the error message under \"Details\" to find out more." ).arg( text ), details );
      }

      break;
    }
    case ERROR_DIRECTORY_NOT_FOUND:
    {
      KMessageBox::error( 0, i18n( "The directory \"%1\" could not be found." ).arg( text ) );

      break;
    }
    case ERROR_FILE_IS_IRREGULAR:
    {
      KMessageBox::error( 0, i18n( "The file \"%1\" is irregular. That means it is either a symlink, a fifo, or something similar. This could indicate that someone is trying to exploit your system. Please inform your system administrator." ).arg( text ) );

      break;
    }
    case ERROR_SYNCHRONIZING:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The synchronization could not the accomplished successfully.\nDetailed information cannot be provided because there was no error message." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The synchronization could not the accomplished successfully.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
    case ERROR_OPENING_FILE:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The file \"%1\" could not be opened." ).arg( text ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The file \"%1\" could not be opened.\nRead the error message under \"Details\" to find out more." ).arg( text ), details );
      }

      break;
    }
    case ERROR_CLOSING_FILE:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The file \"%1\" could not be closed." ).arg( text ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The file \"%1\" could not be closed.\nRead the error message under \"Details\" to find out more." ).arg( text ), details );
      }

      break;
    }
    case ERROR_NET_COMMAND:
    {
      KMessageBox::error( 0, i18n( "The list of arguments for the \"net\" command could not be assembled.\nAt the moment it reads: %1" ).arg( text ) );

      break;
    }
    case ERROR_GETTING_GIDS:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "The list of supplementary group IDs could not be determined." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "The list of supplementary group IDs could not be determined.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
    case ERROR_UNKNOWN:
    default:
    {
      if ( details.stripWhiteSpace().isEmpty() )
      {
        KMessageBox::error( 0, i18n( "An unknown error occurred.\nDetailed information cannot be provided because there was no error message." ) );
      }
      else
      {
        KMessageBox::detailedError( 0, i18n( "An unknown error occurred.\nRead the error message under \"Details\" to find out more." ), details );
      }

      break;
    }
  }
}


int Smb4KError::warning( int code, const QString &, const QString & )
{
  switch ( code )
  {
    default:
    {
      return 0;
    }
  }
}


void Smb4KError::information( int code, const QString &text, const QString &details )
{
  switch ( code )
  {
    case INFO_MIMETYPE_NOT_SUPPORTED:
    {
      KMessageBox::information( 0, i18n( "The mimetype \"%1\" is not supported. Please convert the file to PostScript or PDF." ).arg( text ) );

      break;
    }
    case INFO_DISABLE_SUID_FEATURE:
    {
      KMessageBox::information( 0, i18n( "You previously chose to use \"%1\", but now it is missing on your system. Smb4K will disable this feature." ).arg( text ) );

      break;
    }
    case INFO_BOOKMARK_LABEL_IN_USE:
    {
      KMessageBox::information( 0, i18n( "The label \"%1\" is used more than once. It will automatically be renamed for bookmark \"%2\" to avoid confusion." ).arg( text, details ) );

      break;
    }
    default:
    {
      break;
    }
  }
}

// No moc file needs to be included
