/***************************************************************************
    smb4kauthinfo.cpp  -  This class provides a container for the
    authentication data.
                             -------------------
    begin                : Sa Feb 28 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// application specific includes
#include "smb4kauthinfo.h"


Smb4KAuthInfo::Smb4KAuthInfo( const QString &wg, const QString &h, const QString &s, const QString &u, const QString &p ) : m_workgroup(wg), m_host(h), m_share(s), m_user(u.local8Bit()), m_password(p.local8Bit())
{
}


Smb4KAuthInfo::Smb4KAuthInfo( Smb4KAuthInfo &i ) : m_workgroup( i.workgroup() ), m_host( i.host() ), m_share( i.share() ), m_user( i.user() ), m_password( i.password() )
{
}


Smb4KAuthInfo::~Smb4KAuthInfo()
{
}


void Smb4KAuthInfo::setUser( const QString &user )
{
  m_user = user.local8Bit();
}


void Smb4KAuthInfo::setPassword( const QString &passwd )
{
  m_password = passwd.local8Bit();
}


void Smb4KAuthInfo::setShare( const QString &share )
{
  m_share = share;
}


