/***************************************************************************
    smb4kshareoptions  -  The configuration page for the settings of
    Smb4K regarding share management
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qcheckbox.h>

// KDE includes
#include <klocale.h>
#include <kbuttonbox.h>
#include <kurlrequester.h>
#include <knuminput.h>

// system includes
#include <sys/types.h>
#include <pwd.h>

// applications specific includes
#include "smb4kshareoptions.h"


Smb4KShareOptions::Smb4KShareOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );

  QGroupBox *dir_box = new QGroupBox( 1, Qt::Horizontal, i18n( "Directories" ), this );

  QWidget *prefix_container =   new QWidget( dir_box );
  QGridLayout *prefix_layout =  new QGridLayout( prefix_container );
  prefix_layout->setSpacing( 10 );

  QLabel *prefix =              new QLabel( i18n( "Mount prefix:" ), prefix_container );
  KURLRequester *mount_prefix = new KURLRequester( QString::null, prefix_container,
                                "kcfg_MountPrefix" );
  mount_prefix->setMode( KFile::Directory );
  prefix_layout->addWidget( prefix, 0, 0, 0 );
  prefix_layout->addWidget( mount_prefix, 0, 1, 0 );

  (void) new QCheckBox( i18n( "Force generated subdirectories to be lower case" ),
                        dir_box, "kcfg_ForceLowerCaseSubdirs" );

  QButtonGroup *mount_box = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Mounting and Unmounting" ), this );
  (void) new QCheckBox( i18n( "Unmount all shares of user %1 on exit" ).arg( getpwuid( getuid() )->pw_name ),
                       mount_box, "kcfg_UnmountSharesOnExit" );
  (void) new QCheckBox( i18n( "Remount recently used shares on program start" ),
                       mount_box, "kcfg_RemountShares" );
  (void) new QCheckBox( i18n( "Allow the unmounting of shares that are owned by other users" ),
                        mount_box, "kcfg_UnmountForeignShares" );

  QGroupBox *checks_box = new QGroupBox( 2, QGroupBox::Horizontal, i18n( "Checks" ), this );

  (void) new QLabel( i18n( "Interval between checks:" ), checks_box );
  KIntNumInput *check_interval = new KIntNumInput( 2500, checks_box, 10,
                                 "kcfg_CheckInterval" );
  check_interval->setSuffix( " ms" );
  check_interval->setRange( 500, 300000, 1, false );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addWidget( dir_box, 0, 0, 0 );
  grid->addWidget( mount_box, 1, 0, 0 );
  grid->addWidget( checks_box, 2, 0, 0 );
  grid->addItem( spacer2, 3, 0 );
}

Smb4KShareOptions::~Smb4KShareOptions()
{
}


#include "smb4kshareoptions.moc"
