/***************************************************************************
    smb4ksynchronizeoptions  -  The configuration page for the rsync options
                             -------------------
    begin                : So Nov 20 2005
    copyright            : (C) 2005-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qradiobutton.h>

// KDE includes
#include <klocale.h>
#include <kurlrequester.h>
#include <klineedit.h>
#include <knuminput.h>
#include <klineedit.h>
#include <kfile.h>

// application specific includes
#include "smb4krsyncoptions.h"

Smb4KRsyncOptions::Smb4KRsyncOptions( QWidget *parent, const char *name ) : QTabWidget( parent, name )
{
  setMargin( 10 );

  //
  // The Copying tab
  //
  QWidget *copying_tab = new QWidget( this, "RsyncCopying" );
  QGridLayout *copying_layout = new QGridLayout( copying_tab );
  copying_layout->setSpacing( 10 );

  QGroupBox *directory_box = new QGroupBox( 2, QGroupBox::Horizontal, i18n( "Default Destination" ),
                             copying_tab, "RsyncDestinationBox" );
  directory_box->setInsideSpacing( 5 );

  (void) new QLabel( i18n( "Rsync prefix:" ), directory_box, "RsyncPrefixLabel" );
  KURLRequester *prefix = new KURLRequester( directory_box, "kcfg_RsyncPrefix" );
  prefix->setMode( KFile::Directory | KFile::LocalOnly );

  QButtonGroup *general_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "General" ),
                              copying_tab, "RsyncModeBox" );
  general_box->setInsideSpacing( 5 );

  QCheckBox *archive_mode = new QCheckBox( i18n( "Archive mode" ), general_box, "kcfg_ArchiveMode" );
  QCheckBox *recursive = new QCheckBox( i18n( "Recurse into directories" ), general_box, "kcfg_RecurseIntoDirectories" );
  (void) new QCheckBox( i18n( "Skip files that are newer in target directory" ), general_box, "kcfg_UpdateTarget" );
  (void) new QCheckBox( i18n( "Update destination files in place" ), general_box, "kcfg_UpdateInPlace" );
  (void) new QCheckBox( i18n( "Use relative path names" ), general_box, "kcfg_RelativePathNames" );
  (void) new QCheckBox( i18n( "Don't send implied directories" ), general_box, "kcfg_NoImpliedDirectories" );
  (void) new QCheckBox( i18n( "Transfer directories without recursing" ), general_box, "kcfg_TransferDirectories" );
  (void) new QCheckBox( i18n( "Compress data during transfer" ), general_box, "kcfg_CompressData" );

  QButtonGroup *links_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Links" ), copying_tab, "RsyncModeBox" );
  links_box->setInsideSpacing( 5 );

  QCheckBox *links = new QCheckBox( i18n( "Preserve symlinks" ), links_box, "kcfg_PreserveSymlinks" );
  (void) new QCheckBox( i18n( "Transform symlinks" ), links_box, "kcfg_TransformSymlinks" );
  (void) new QCheckBox( i18n( "Only transform unsafe symlinks" ), links_box, "kcfg_TransformUnsafeSymlinks" );
  (void) new QCheckBox( i18n( "Ignore unsafe symlinks" ), links_box, "kcfg_IgnoreUnsafeSymlinks" );
  (void) new QCheckBox( i18n( "Preserve hard links" ), links_box, "kcfg_PreserveHardLinks" );
  (void) new QCheckBox( i18n( "Keep directory symlinks" ), links_box, "kcfg_KeepDirectorySymlinks" );

  QButtonGroup *perm_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "File Permissions, etc." ),
                           copying_tab, "RsyncPreservationBox" );
  perm_box->setInsideSpacing( 5 );

  QCheckBox *perms = new QCheckBox( i18n( "Preserve permissions" ), perm_box, "kcfg_PreservePermissions" );
  QCheckBox *group = new QCheckBox( i18n( "Preserve group" ), perm_box, "kcfg_PreserveGroup" );
  QCheckBox *owner = new QCheckBox( i18n( "Preserve owner" ), perm_box, "kcfg_PreserveOwner" );
  QCheckBox *devices = new QCheckBox( i18n( "Preserve device and special files" ), perm_box, "kcfg_PreserveDevicesAndSpecials" );
  QCheckBox *times = new QCheckBox( i18n( "Preserve times" ), perm_box, "kcfg_PreserveTimes" );
  (void) new QCheckBox( i18n( "Omit directories when preserving times" ), perm_box, "kcfg_OmitDirectoryTimes" );

  QSpacerItem *spacer1 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  copying_layout->addWidget( directory_box, 0, 0, 0 );
  copying_layout->addWidget( general_box, 1, 0, 0 );
  copying_layout->addWidget( links_box, 2, 0, 0 );
  copying_layout->addWidget( perm_box, 3, 0, 0 );
  copying_layout->addItem( spacer1, 4, 0 );

  addTab( copying_tab, i18n( "Copying" ) );


  //
  // The File Deletion & Transfer tab
  //
  QWidget *deltrans_tab = new QWidget( this, "RsyncFileDeletion" );
  QGridLayout *deltrans_layout = new QGridLayout( deltrans_tab );
  deltrans_layout->setSpacing( 10 );

  QButtonGroup *delete_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "File Deletion" ), deltrans_tab, "RsyncDeleteBox" );
  delete_box->setInsideSpacing( 5 );

  (void) new QCheckBox( i18n( "Remove synchronized source files" ), delete_box, "kcfg_RemoveSourceFiles" );
  (void) new QCheckBox( i18n( "Delete extraneous files" ), delete_box, "kcfg_DeleteExtraneous" );
  (void) new QCheckBox( i18n( "Delete files before transfer" ), delete_box, "kcfg_DeleteBefore" );
  (void) new QCheckBox( i18n( "Delete files after transfer" ), delete_box, "kcfg_DeleteAfter" );
  (void) new QCheckBox( i18n( "Delete files during transfer" ), delete_box, "kcfg_DeleteDuring" );
  (void) new QCheckBox( i18n( "Also delete excluded files" ), delete_box, "kcfg_DeleteExcluded" );
  (void) new QCheckBox( i18n( "Delete even if I/O errors occur" ), delete_box, "kcfg_IgnoreErrors" );
  (void) new QCheckBox( i18n( "Force deletion of non-void directories" ), delete_box, "kcfg_ForceDirectoryDeletion" );

  QButtonGroup *delete_restrictions_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Restrictions" ), deltrans_tab, "RsyncDeleteRestrictionsBox" );
  delete_restrictions_box->setInsideSpacing( 5 );

  (void) new QCheckBox( i18n( "Don't delete more than this many files:" ), delete_restrictions_box, "kcfg_UseMaximumDelete" );
  (void) new KIntNumInput( delete_restrictions_box, "kcfg_MaximumDeleteValue" );

  QButtonGroup *transfer_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "File Transfer" ),
                               deltrans_tab, "RsyncFileTransferBox" );
  transfer_box->setInsideSpacing( 5 );

  (void) new QCheckBox( i18n( "Don't transfer any file smaller than:" ), transfer_box, "kcfg_UseMinimalTransferSize" );
  KIntNumInput *min_size = new KIntNumInput( transfer_box, "kcfg_MinimalTransferSize" );
  min_size->setSuffix( " kB" );
  (void) new QCheckBox( i18n( "Don't transfer any file larger than:" ), transfer_box, "kcfg_UseMaximalTransferSize" );
  KIntNumInput *max_size = new KIntNumInput( transfer_box, "kcfg_MaximalTransferSize" );
  max_size->setSuffix( " kB" );
  (void) new QCheckBox( i18n( "Keep partially transferred files" ), transfer_box, "kcfg_KeepPartial" );
  transfer_box->addSpace( 0 );
  (void) new QCheckBox( i18n( "Put a partially transferred file into:" ), transfer_box, "kcfg_UsePartialDirectory" );
  KURLRequester *partial_dir = new KURLRequester( transfer_box, "kcfg_PartialDirectory" );
  partial_dir->setMode( KFile::Directory | KFile::LocalOnly );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  deltrans_layout->addWidget( delete_box, 0, 0, 0 );
  deltrans_layout->addWidget( delete_restrictions_box, 1, 0, 0 );
  deltrans_layout->addWidget( transfer_box, 2, 0, 0 );
  deltrans_layout->addItem( spacer2, 3, 0 );

  addTab( deltrans_tab, i18n( "File Deletion && Transfer" ) );


  //
  // The Filter tab
  //
  QWidget *filter_tab = new QWidget( this, "RsyncFiltering" );
  QGridLayout *filter_layout = new QGridLayout( filter_tab );
  filter_layout->setSpacing( 10 );

  QButtonGroup *general_filter_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "General" ),
                                     filter_tab, "RsyncGeneralFilterBox" );
  general_filter_box->setInsideSpacing( 5 );

  (void) new QCheckBox( i18n( "Auto-ignore files in the same way CVS does" ), general_filter_box, "kcfg_UseCVSExclude" );
  general_filter_box->addSpace( 0 );
  (void) new QCheckBox( i18n( "Exclude files matching this pattern:" ), general_filter_box, "kcfg_UseExcludePattern" );
  (void) new KLineEdit( general_filter_box, "kcfg_ExcludePattern" );
  (void) new QCheckBox( i18n( "Read exclude patterns from:" ), general_filter_box, "kcfg_UseExcludeFrom" );
  KURLRequester *exclude_from = new KURLRequester( general_filter_box, "kcfg_ExcludeFrom" );
  exclude_from->setMode( KFile::File | KFile::LocalOnly );
  (void) new QCheckBox( i18n( "Don't exclude files matching this pattern:" ), general_filter_box, "kcfg_UseIncludePattern" );
  (void) new KLineEdit( general_filter_box, "kcfg_IncludePattern" );
  (void) new QCheckBox( i18n( "Read include patterns from:" ), general_filter_box, "kcfg_UseIncludeFrom" );
  KURLRequester *include_from = new KURLRequester( general_filter_box, "kcfg_IncludeFrom" );
  include_from->setMode( KFile::File | KFile::LocalOnly );

  QButtonGroup *filter_rules_box = new QButtonGroup( 1, QGroupBox::Horizontal, i18n( "Filter Rules" ),
                                   filter_tab, "RsyncFilterRulesBox" );
  filter_rules_box->setInsideSpacing( 5 );
  QLabel *filter_rules_label = new QLabel( i18n( "The rules defined below will be added to the \"rsync\" command as they are. Thus, you have to start with the --filter=... argument." ), filter_rules_box );
  filter_rules_label->setTextFormat( Qt::RichText );
  (void) new KLineEdit( filter_rules_box, "kcfg_CustomFilteringRules" );
  (void) new QLabel( i18n( "Special filter rules:" ), filter_rules_box );
  QCheckBox *f_filter = new QCheckBox( i18n( "Use --filter='dir-merge /.rsync-filter' filter rule" ), filter_rules_box, "kcfg_UseFFilterRule" );
  QCheckBox *ff_filter = new QCheckBox( i18n( "Use --filter='exclude .rsync-filter' filter rule" ), filter_rules_box, "kcfg_UseFFFilterRule" );

  QSpacerItem *spacer3 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  filter_layout->addWidget( general_filter_box, 0, 0, 0 );
  filter_layout->addWidget( filter_rules_box, 1, 0, 0 );
  filter_layout->addItem( spacer3, 2, 0 );

  addTab( filter_tab, i18n( "Filtering" ) );


  //
  // The Advanced tab
  //
  QWidget *advanced_tab = new QWidget( this, "RsyncAdvanced" );
  QGridLayout *advanced_layout = new QGridLayout( advanced_tab );
  advanced_layout->setSpacing( 10 );

  QButtonGroup *misc_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "General" ),
                           advanced_tab, "RsyncAdvancedMiscBox" );
  misc_box->setInsideSpacing( 5 );

  (void) new QCheckBox( i18n( "Handle sparse files efficiently" ), misc_box, "kcfg_EfficientSparseFileHandling" );
  (void) new QCheckBox( i18n( "Copy files whole (no rsync algorithm)" ), misc_box, "kcfg_CopyFilesWhole" );
  (void) new QCheckBox( i18n( "Don't cross file system boundaries" ), misc_box, "kcfg_OneFileSystem" );
  (void) new QCheckBox( i18n( "Only update files that already exist" ), misc_box, "kcfg_UpdateExisting" );
  (void) new QCheckBox( i18n( "Ignore files that already exist" ), misc_box, "kcfg_IgnoreExisting" );
  (void) new QCheckBox( i18n( "Delay updates until the end of transfer" ), misc_box, "kcfg_DelayUpdates" );

  QButtonGroup *backup_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Backup" ), advanced_tab, "RsyncBackupBox" );
  backup_box->setInsideSpacing( 5 );

  QCheckBox *backup = new QCheckBox( i18n( "Make backups" ), backup_box, "kcfg_MakeBackups" );
  backup_box->addSpace( 0 );
  (void) new QCheckBox( i18n( "Backup suffix:" ), backup_box, "kcfg_UseBackupSuffix" );
  (void) new KLineEdit( backup_box, "kcfg_BackupSuffix" );
  (void) new QCheckBox( i18n( "Backup directory:" ), backup_box, "kcfg_UseBackupDirectory" );
  KURLRequester *backup_dir = new KURLRequester( backup_box, "kcfg_BackupDirectory" );
  backup_dir->setMode( KFile::Directory | KFile::LocalOnly );

  QButtonGroup *checksum_box = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Checksums" ), advanced_tab, "RsyncChecksumsBox" );
  checksum_box->setInsideSpacing( 5 );

  (void) new QCheckBox( i18n( "Force fixed checksum block size:" ), checksum_box, "kcfg_UseBlockSize" );
  (void) new KIntNumInput( checksum_box, "kcfg_BlockSize" );
  (void) new QCheckBox( i18n( "Set block/file checksum seed:" ), checksum_box, "kcfg_UseChecksumSeed" );
  (void) new KIntNumInput( checksum_box, "kcfg_ChecksumSeed" );
  (void) new QCheckBox( i18n( "Skip files based on checksum" ), checksum_box, "kcfg_UseChecksum" );
  checksum_box->addSpace( 0 );

  QSpacerItem *spacer4 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  advanced_layout->addWidget( misc_box, 0, 0, 0 );
  advanced_layout->addWidget( backup_box, 1, 0, 0 );
  advanced_layout->addWidget( checksum_box, 2, 0, 0 );
  advanced_layout->addItem( spacer4, 3, 0 );

  addTab( advanced_tab, i18n( "Advanced" ) );

  connect( archive_mode, SIGNAL( toggled( bool ) ),
           this,         SLOT( slotArchiveToggled( bool ) ) );

  connect( recursive,    SIGNAL( toggled( bool ) ),
           this,         SLOT( slotUncheckArchive( bool ) ) );

  connect( links,        SIGNAL( toggled( bool ) ),
           this,         SLOT( slotUncheckArchive( bool ) ) );

  connect( perms,        SIGNAL( toggled( bool ) ),
           this,         SLOT( slotUncheckArchive( bool ) ) );

  connect( times,        SIGNAL( toggled( bool ) ),
           this,         SLOT( slotUncheckArchive( bool ) ) );

  connect( group,        SIGNAL( toggled( bool ) ),
           this,         SLOT( slotUncheckArchive( bool ) ) );

  connect( owner,        SIGNAL( toggled( bool ) ),
           this,         SLOT( slotUncheckArchive( bool ) ) );

  connect( devices,      SIGNAL( toggled( bool ) ),
           this,         SLOT( slotUncheckArchive( bool ) ) );

  connect( backup,       SIGNAL( toggled( bool ) ),
           this,         SLOT( slotBackupToggled( bool ) ) );

  connect( f_filter,     SIGNAL( toggled( bool ) ),
           this,         SLOT( slotFShortcutToggled( bool ) ) );

  connect( ff_filter,    SIGNAL( toggled( bool ) ),
           this,         SLOT( slotFFShortcutToggled( bool ) ) );

  slotArchiveToggled( true );
  slotBackupToggled( false );
}


Smb4KRsyncOptions::~Smb4KRsyncOptions()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KRsyncOptions::slotArchiveToggled( bool on )
{
  if ( on )
  {
    static_cast<QCheckBox *>( child( "kcfg_RecurseIntoDirectories", "QCheckBox", true ) )->setChecked( on );
    static_cast<QCheckBox *>( child( "kcfg_PreserveSymlinks", "QCheckBox", true ) )->setChecked( on );
    static_cast<QCheckBox *>( child( "kcfg_PreservePermissions", "QCheckBox", true ) )->setChecked( on );
    static_cast<QCheckBox *>( child( "kcfg_PreserveTimes", "QCheckBox", true ) )->setChecked( on );
    static_cast<QCheckBox *>( child( "kcfg_PreserveGroup", "QCheckBox", true ) )->setChecked( on );
    static_cast<QCheckBox *>( child( "kcfg_PreserveOwner", "QCheckBox", true ) )->setChecked( on );
    static_cast<QCheckBox *>( child( "kcfg_PreserveDevicesAndSpecials", "QCheckBox", true ) )->setChecked( on );
  }
}


void Smb4KRsyncOptions::slotUncheckArchive( bool on )
{
  if ( !on )
  {
    static_cast<QCheckBox *>( child( "kcfg_ArchiveMode", "QCheckBox", true ) )->setChecked( on );
  }
}


void Smb4KRsyncOptions::slotBackupToggled( bool on )
{
  static_cast<QCheckBox *>( child( "kcfg_UseBackupDirectory", "QCheckBox", true ) )->setEnabled( on );
  static_cast<KURLRequester *>( child( "kcfg_BackupDirectory", "KURLRequester", true ) )->setEnabled( on );
  static_cast<QCheckBox *>( child( "kcfg_UseBackupSuffix", "QCheckBox", true ) )->setEnabled( on );
  static_cast<KLineEdit *>( child( "kcfg_BackupSuffix", "KLineEdit", true ) )->setEnabled( on );
}


void Smb4KRsyncOptions::slotFShortcutToggled( bool on )
{
  QCheckBox *ff_filter = static_cast<QCheckBox *>( child( "kcfg_UseFFFilterRule", "QCheckBox", true ) );

  if ( on && ff_filter->isChecked() )
  {
    ff_filter->setChecked( false );
  }
}


void Smb4KRsyncOptions::slotFFShortcutToggled( bool on )
{
  QCheckBox *f_filter = static_cast<QCheckBox *>( child( "kcfg_UseFFilterRule", "QCheckBox", true ) );

  if ( on && f_filter->isChecked() )
  {
    f_filter->setChecked( false );
  }
}

#include "smb4krsyncoptions.moc"
