/***************************************************************************
    smb4knetworkbrowsertooltip  -  Tool tip for the network browser.
                             -------------------
    begin                : Sa Jan 20 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KNETWORKBROWSERTOOLTIP_H
#define SMB4KNETWORKBROWSERTOOLTIP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qlabel.h>
#include <qlayout.h>

// Forward declarations:
class Smb4KNetworkBrowserItem;


/**
 * This class provides the tool tip for the network browser
 * of Smb4K. It shows information about the associated share.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KNetworkBrowserToolTip : public QLabel
{
  Q_OBJECT

  public:
    /**
     * The constructor
     *
     * @param item            The Smb4KNetworkBrowserItem object for which
     *                        a tool tip should be shown.
     */
    Smb4KNetworkBrowserToolTip( Smb4KNetworkBrowserItem *item );

    /**
     * The destructor
     */
    ~Smb4KNetworkBrowserToolTip();

    /**
     * Show the tool tip. Please note that the tool tip will not be shown
     * exactly at position @p pos but with a displacement of 5 pixels in x-
     * and y-direction.
     */
    void showTip( const QPoint &pos );

    /**
     * If you need to update the tool tip while it is shown, this is the function
     * you want to use. It rereads the entries from the assossiated
     * Smb4KNetworkBrowserItem object and modifies the tool tip if changes happened.
     */
    void update();

    /**
     * Returns the Smb4KNetworkBrowserItem object for which the tool tip
     * should be shown.
     *
     * @returns a pointer to a Smb4KNetworkBrowserItem object.
     */
    Smb4KNetworkBrowserItem *item() { return m_item; }

  protected:
    /**
     * Reimplemented from QLabel.
     */
    void mousePressEvent( QMouseEvent *e );

    /**
     * Reimplemented from QLabel.
     */
    void leaveEvent( QEvent *e );

  protected slots:
    /**
     * This slot hides the tool tip after 10 sec.
     */
    void slotHideToolTip();

  private:
    /**
     * The pointer to the Smb4KNetworkBrowserItem object
     */
    Smb4KNetworkBrowserItem *m_item;

    /**
     * The layout for the tool tip
     */
    QGridLayout *m_layout;

    /**
     * Set up the tool tip
     */
    void setupTip();
};

#endif
