/***************************************************************************
 *   Copyright (C) 2004 by Massimo Callegari                               *
 *   massimo.callegari@telsey.it                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef SAMBROWSER_H
#define SAMBROWSER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <konqsidebarplugin.h>
#include <qstring.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qwidgetstack.h>
#include <kpopupmenu.h>
#include <ktoolbar.h>
#include <khtml_part.h>
// KDE includes
#include <kaction.h>
#include <kparts/dockmainwindow.h>
#include <kparts/part.h>
#include <kparts/factory.h>


class smb4kWidget : public QVBox
{
Q_OBJECT
public:
    smb4kWidget( QWidget * parent = 0, const char * name = 0, WFlags f = 0 );

private:

};

class KonqSidebar_Smb4K : public KonqSidebarPlugin
{
    Q_OBJECT
public:
    /**
     * Construct a @ref KonqSidebarPlugin.
     *
     * @param inst The sidebar's kinstance class.
     * @param parent The sidebar internal button info class responsible for this plugin.
     * @param widgetParent The container which will contain the plugins widget.
     * @param desktopName The filename of the configuration file.
     * @param name A Qt object name for your plugin.
     **/
     KonqSidebar_Smb4K(KInstance *inst,QObject *parent,QWidget *widgetParent, QString &desktopName, const char* name=0);

    /** destructor */
    ~KonqSidebar_Smb4K();

    KHTMLPart* m_part;
    virtual QWidget *getWidget(){ return (QWidget*)widget;}
    virtual void *provides(const QString &) {return 0;}
    void emitStatusBarText (const QString &) {;}

private:
    /**
     * The browser part
     */
    KParts::Part *m_browser_part;

    /**
     * The search dialog part
     */
    KParts::Part *m_search_part;

protected:
     /**
      * The main plugin widget. Contains a klistview and a ktoolbox objects
      */
     smb4kWidget *widget;

     QString                currentKonquerorURL;


    virtual void handleURL(const KURL &url);
protected slots:
    /**
     * This slot initializes a rescan of the network neighborhood.
     */
    void slotRescan();
    /**
     * This slot is connected to the clicked() signal of the topBar search button
     * It brings up the "Search" dialog.
     */
    void slotSearch();
    /**
     * Opens the configuration dialog.
     */
    void slotSmb4KOptionsDlg();
    /**
     * This slot is invoked when the config dialog is closed and the settings have
     * been changed. Emits the reloadSettings() signal and adjusts the system tray
     * widget to the new settings afterwards.
     */
    void slotSettingsChanged();
    /**
     * Called from mounter when a share is mounted
     */
    void slotMountedShare( const QString & );
    /**
     * Called from the mounter just before a share is unmounted. This slot
     * changes the URL to the user's home so that we can unmount the share
     * without problems.
     *
     * @param mountpoint      The mount point of the share that's going to
     *                        be unmounted.
     */
    void slotPrepareUnmount( const QString &mounpoint );
  signals:
    // see <konqsidebarplugin.h>
    void openURLRequest(const KURL &url,
                        const KParts::URLArgs &args = KParts::URLArgs());
};

#endif
