#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of 
# the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Copyright 2007-2008 Martin Böhm <martin.bohm@kubuntu.org>
# Copyright 2007-2008 Michael Anderson <nosrednaekim@gmail.com>

import sys
import os
from optparse import OptionParser
from qt import *
from kdeui import *
from kdecore import *
# for adept batch launching
import subprocess
# for compiz-kde package checking
import apt_pkg
from apt.progress import OpProgress

from DesktopEffectsDialog import DesktopEffectsDialog
from DesktopEffectsCommon import DesktopEffectsCommon

import gettext
def _(str):
    return unicode(gettext.gettext(str), 'UTF-8')
def __(catalog,str):
    return unicode(gettext.dgettext(catalog, str), 'UTF-8')
def utf8(str):
  if isinstance(str, unicode):
      return str
  return unicode(str, 'UTF-8')

class DesktopEffectsKDE(DesktopEffectsDialog, DesktopEffectsCommon):
    def __init__(self):
      '''launches the app, draws the window '''
      
      app = KApplication (sys.argv, "gd-test")
      DesktopEffectsCommon.__init__(self)
      DesktopEffectsDialog.__init__(self)
      # bind the locale
      localesApp="desktop-effects"
      localesDir="/opt/kde3/share/locale"
      gettext.bindtextdomain(localesApp, localesDir)
      gettext.textdomain(localesApp)
      # initialize variables

      # self.action contains the action to be done after the user clicks "Apply".
      # 0 - do not do anything
      # 1 - disable effects
      # 2 - set standard effects
      # 3 - set extra effects
      # 4 - keep the custom effects, or revert to the last known effects state
      self.action = 0

      # set the screenshot pictures
      self.noEffectsImage.setPixmap(QPixmap("./data/noeffects.png"))
      self.standardEffectsImage.setPixmap(QPixmap("./data/standardeffects.png"))
      self.extraEffectsImage.setPixmap(QPixmap("./data/extraeffects.png"))

      # set the translations & icons
      # Apply
      self.applyButton.setText(__("kdelibs","&Apply"))
      self.applyButton.setIconSet(KGlobal.iconLoader().loadIconSet("apply",
                                                                   KIcon.NoGroup, KIcon.SizeSmall))

      # Close    
      self.cancelButton.setText(__("kdelibs","&Cancel"))
      self.cancelButton.setIconSet(KGlobal.iconLoader().loadIconSet("cancel", 
                                                                   KIcon.NoGroup, KIcon.SizeSmall))

      # check the state
      self.check()

      app.setMainWidget(self)
      self.show()
      app.exec_loop()


    def check(self):
      ''' checks the state and changes the UI accordingly. '''
      self.installed = self.checkInstalled()
      self.enabled   = self.checkEnabled()
      if(self.installed == True):
          self.installButton.setText(_("&Remove Desktop Effects"))
          self.effectsGroup.setDisabled(False)
          self.warningText.show()
          self.warningIcon.show()
          self.packageText.setText(_("The Compiz engine is installed in your system."))
          self.installButton.setIconSet(KGlobal.iconLoader().loadIconSet("remove",KIcon.NoGroup,KIcon.SizeSmall))
          # remove, not install
          self.rm = True
      else:
          self.packageText.setText(_("In order for Compiz Desktop Effects to work,"
                                     " the Compiz engine must be installed on your system."))
          self.installButton.setText(_("&Install Desktop Effects"))
          self.warningText.show()
          self.warningIcon.show()
          # install, not remove
          self.rm = False
          #self.effectsBox.setDisabled(True)
          self.installButton.setIconSet(KGlobal.iconLoader().loadIconSet("add",KIcon.NoGroup,KIcon.SizeSmall))

    def checkInstalled(self):
        progress = OpProgress()
        cache = apt_pkg.GetCache(progress)
        for pkg in cache.Packages:
            if pkg.Name == "compiz-kde-kde3":
                if pkg.CurrentVer is not None:
                    return True
        # otherwise
        return False
    def checkEnabled(self):
        return False

    def cancel(self):
        ''' action to be done after the user clicks the "cancel" button '''
        self.close()

    def apply(self):
        ''' action to be done after the user click the "apply button '''
        # if self.action > 0:
        #   if self.action == 1:
        #   elif self.action == 2:
        #   elif self.action == 3:
        #   elif self.action == 4:
        self.close()


    def installButtonClicked(self):
        ''' Installs or removes the compiz packages. '''
        if self.rm == True:
            self.remove()
        else:
            self.install()

        # check (again) if the package is installed
        self.check()
