# -*- coding: utf-8 -*-
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of 
# the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Copyright 2007-2008 Martin Böhm <martin.bohm@kubuntu.org>
# Copyright 2007-2008 Michael Anderson <nosrednaekim@gmail.com>

# a class hosting the desktop-independent methods for the Desktop
# Effects Dialog

import sys
import os
from optparse import OptionParser

# for adept batch launching
import subprocess
# for compiz-kde package checking
import apt_pkg
from apt.progress import OpProgress

import gettext
def _(str):
    return unicode(gettext.gettext(str), 'UTF-8')
def __(catalog,str):
    return unicode(gettext.dgettext(catalog, str), 'UTF-8')
def utf8(str):
  if isinstance(str, unicode):
      return str
  return unicode(str, 'UTF-8')

class DesktopEffectsCommon(object):
    def __init__(self):
        self.action = 0
        self.ibText = ""
        self.check()
        self.DATADIR = "/opt/kde3/share/apps/desktop-effects-kde/"

    def checkInstalled(self):
        progress = OpProgress()
        cache = apt_pkg.GetCache(progress)
        for pkg in cache.Packages:
            if pkg.Name == "compiz-kde-kde3":
                if pkg.CurrentVer is not None:
                    return True
        # otherwise
        return False

    def checkEnabled(self):
	    '''checks if the compizasWM file is present, and if so, reads what mode we are in'''
	    if os.path.exists(os.path.expanduser("~/.kde3/share/config/compizasWM")):
		    compizasWM = open(os.path.expanduser("~/.kde3/share/config/compizasWM"))
		    state = compizasWM.readline()
		    return state
	    else:
		    return False

    def check(self):
      ''' checks the state and changes the UI accordingly. '''
      self.installed = self.checkInstalled()
      self.enabled   = self.checkEnabled()			
      if(self.installed == True):
          self.ibText = _("&Remove Desktop Effects")
          self.showWarning()
          self.enable()
          self.pText = _("The Compiz engine is installed in your system.")
          # remove, not install
          self.rm = True
      else:
          self.pText = _("In order for Compiz Desktop Effects to work,"
                         " the Compiz engine must be installed on your system.")
          self.ibText = _("&Install Desktop Effects")
          self.hideWarning()
          self.disable()
          # install, not remove
          self.rm = False
          #self.effectsBox.setDisabled(True)

    def showWarning(self):
        ''' shows the warning information, should be implemented in the UI class '''
        raise NotImplementedError

    def hideWarning(self):
        ''' hides the warning, should be implemented in the UI class '''
        raise NotImplementedError

    def disable(self):
        ''' disables the options, should be implemented in the UI '''
        raise NotImplementedError

    def enable(self):
        ''' enables the options, should be implemented in the UI '''
        raise NotImplementedError

    def done(self):
        ''' action to be done after the user clicks the "cancel" button '''
        print "signalled" # DEBUG
        self.close()

    def apply(self):
        ''' action to be done after the user clicks the "apply button '''
        print "apply clicked" #DEBUG
        if self.action > 0:
           if self.action == 1:
			 self.disableEffects()
			 
           elif self.action == 2:
			 self.enableStandardEffects()
           elif self.action == 3:
			 self.enableExtraEffects()
           elif self.action == 4:
			 self.enableCustomEffects()
	   if not self.enabled and not self.action == 1:
		 os.spawnl(os.P_NOWAIT, "/opt/kde3/bin/compiz", "--replace")
		 self.enabled = True		  	 		 

    def btnInstallClicked(self):
        if self.installed == True:
            self.remove()
            return
        try:
            ''' Installs the Compiz package. Not very nice as it is distribution dependent. '''
            subprocess.call(['kdesudo', '-c' '/opt/kde3/bin/adept_batch install compiz-kde-kde3 compiz-fusion-plugins-main-kde3 compiz-fusion-plugins-extra-kde3'])
        except:
            subprocess.call(['kdialog', '--sorry', 'Adept Batch is not installed on this system'])
        self.check()


    # the functions toggled by radio boxes
    def noEffects(self):
        print "radio toggled" # DEBUG
        self.action = 1
#        self.apply()
    def standardEffects(self):
        print "radio toggled" # DEBUG
        self.action = 2
#        self.apply()
    def extraEffects(self):
        print "radio toggled" # DEBUG
        self.action = 3
    def customEffects(self):
        print "radio toggled" # DEBUG
        self.action = 4
#        self.apply()

    def remove(self):
        removeAnswer = subprocess.call(['kdialog', "--warningyesno", "Are you sure you wish to remove Compiz KDE?"])
        if removeAnswer == 0:
            try:
                ''' Remove the Compiz package. Not very nice as it is distribution dependent. '''
                subprocess.call(['kdesudo', '-c' '/opt/kde3/bin/adept_batch remove compiz-kde-kde3 compiz-fusion-plugins-main-kde3 compiz-fusion-plugins-extra-kde3'])
            except:
                subprocess.call(['kdialog', '--sorry', 'Adept Batch is not installed on this system'])
			 	 

    def disableEffects(self):
	    '''remove compiz as the default WM'''
	    os.remove(os.path.expanduser("~/.kde3/share/config/compizasWM"))
	    self.enabled = False 

    
    def enableStandardEffects(self):
	    '''copy the .ini to Default.ini and enable compiz as default WM'''
	    code = os.system('mkdir -p ~/.config/compiz/compizconfig')
	    try:
	    		enable = open(os.path.expanduser("~/.kde3/share/config/compizasWM"),"w")
	    		if enable.readline() == "custom":
	    			customeffects = open(os.path.expanduser("~/.config/compiz/compizconfig/Default.ini"),"r")
				backupfile = open(os.path.expanduser("~/.config/compiz/compizconfig/Custom.ini"),"w")
				backupfile.write(customeffects)
				backupfile.close()
				customeffects.close()
	    except:
			print "error"		
	    enable.write("standardeffects")
	    enable.close()
	    config = open(os.path.join(self.DATADIR,"MediumEffects.ini"),"r")
	    dest = open(os.path.expanduser("~/.config/compiz/compizconfig/Default.ini"),"w")
	    dest.write(config.read())
	    dest.close()
	    config.close()
	    print "standardEffects enabled" #DEBUG
	    
    def enableExtraEffects(self):
	    ''' copy the extraeffects.ini to Default.ini and enable compiz as defaultWM'''
	    code = os.system('mkdir -p ~/.config/compiz/compizconfig')
	    if os.path.exists(os.path.expanduser("~/.kde3/share/config/compizasWM")):
	    		enable = open(os.path.expanduser("~/.kde3/share/config/compizasWM"),"r")
	    		if enable.readline() == "custom":
	    			customeffects = open(os.path.expanduser("~/.config/compiz/compizconfig/Default.ini"),"r")
				backupfile = open(os.path.expanduser("~/.config/compiz/compizconfig/Custom.ini"),"w")
				backupfile.write(customeffects)
				backupfile.close()
				customeffects.close()
				enable.close()

	    enable = open(os.path.expanduser("~/.kde3/share/config/compizasWM"),"w")	
	    enable.write("extraeffects")
	    enable.close()
	    config = open(os.path.join(self.DATADIR,"HighEffects.ini"),"r")
	    dest = open(os.path.expanduser("~/.config/compiz/compizconfig/Default.ini"),"w")
	    dest.write(config.read())
	    dest.close()
	    config.close()
	    print "extraEffects enabled" #DEBUG
	    
    def enableCustomEffects(self):
	    code = os.system('mkdir -p ~/.config/compiz/compizconfig')
	    try:
		    config = open(os.path.expanduser("~/.config/compiz/compizconfig/Custom.ini"),"r")
	    except:
		    print "no custom effects file, creating blank .ini" #DEBUG
		    config = open(os.path.join(self.DATADIR,"BlankEffects.ini"),"r")
	    enable = open(os.path.expanduser("~/.kde3/share/config/compizasWM"),"w")
	    enable.write("custom")
	    enable.close()	    
	    dest = open(os.path.expanduser("~/.config/compiz/compizconfig/Default.ini"),"w")
	    dest.write(config.read())
	    dest.close()
	    config.close()
