include(FindQt3)

# - Find the KDE3 include and library dirs, KDE preprocessors and define a some macros
#
# This module defines the following variables:
#  KDE3_DEFINITIONS         - compiler definitions required for compiling KDE software
#  KDE3_INCLUDE_DIR         - the KDE include directory
#  KDE3_INCLUDE_DIRS        - the KDE and the Qt include directory, for use with INCLUDE_DIRECTORIES()
#  KDE3_LIB_DIR             - the directory where the KDE libraries are installed, for use with LINK_DIRECTORIES()
#  QT_AND_KDECORE_LIBS      - this contains both the Qt and the kdecore library
#  KDE3_DCOPIDL_EXECUTABLE  - the dcopidl executable
#  KDE3_DCOPIDL2CPP_EXECUTABLE - the dcopidl2cpp executable
#  KDE3_KCFGC_EXECUTABLE    - the kconfig_compiler executable
#  KDE3_FOUND               - set to TRUE if all of the above has been found
#
# The following user adjustable options are provided:
#
#  KDE3_BUILD_TESTS - enable this to build KDE testcases
#
#
# It also adds the following macros (from KDE3Macros.cmake)
# SRCS_VAR is always the variable which contains the list of source files for your application or library.
#
# KDE3_AUTOMOC(file1 ... fileN)
#    Call this if you want to have automatic moc file handling.
#    This means if you include "foo.moc" in the source file foo.cpp
#    a moc file for the header foo.h will be created automatically.
#    You can set the property SKIP_AUTOMAKE using SET_SOURCE_FILES_PROPERTIES()
#    to exclude some files in the list from being processed.
#
# KDE3_ADD_MOC_FILES(SRCS_VAR file1 ... fileN )
#    If you don't use the KDE3_AUTOMOC() macro, for the files
#    listed here moc files will be created (named "foo.moc.cpp")
#
# KDE3_ADD_DCOP_SKELS(SRCS_VAR header1.h ... headerN.h )
#    Use this to generate DCOP skeletions from the listed headers.
#
# KDE3_ADD_DCOP_STUBS(SRCS_VAR header1.h ... headerN.h )
#     Use this to generate DCOP stubs from the listed headers.
#
# KDE3_ADD_UI_FILES(SRCS_VAR file1.ui ... fileN.ui )
#    Use this to add the Qt designer ui files to your application/library.
#
# KDE3_ADD_KCFG_FILES(SRCS_VAR file1.kcfgc ... fileN.kcfgc )
#    Use this to add KDE kconfig compiler files to your application/library.
#
# KDE3_INSTALL_LIBTOOL_FILE(target)
#    This will create and install a simple libtool file for the given target.
#
# KDE3_ADD_EXECUTABLE(name file1 ... fileN )
#    Currently identical to ADD_EXECUTABLE(), may provide some advanced features in the future.
#
# KDE3_ADD_KPART(name [WITH_PREFIX] file1 ... fileN )
#    Create a KDE plugin (KPart, kioslave, etc.) from the given source files.
#    If WITH_PREFIX is given, the resulting plugin will have the prefix "lib", otherwise it won't.
#    It creates and installs an appropriate libtool la-file.
#
# KDE3_ADD_KDEINIT_EXECUTABLE(name file1 ... fileN )
#    Create a KDE application in the form of a module loadable via kdeinit.
#    A library named kdeinit_<name> will be created and a small executable which links to it.
#
# The option KDE3_ENABLE_FINAL to enable all-in-one compilation is
# no longer supported.
#
#
# Author: Alexander Neundorf <neundorf@kde.org>

IF(NOT UNIX AND KDE3_FIND_REQUIRED)
   MESSAGE(FATAL_ERROR "Compiling KDE3 applications and libraries under Windows is not supported")
ENDIF(NOT UNIX AND KDE3_FIND_REQUIRED)

# If Qt4 has already been found, fail.
IF(QT4_FOUND)
  IF(KDE3_FIND_REQUIRED)
    MESSAGE( FATAL_ERROR "KDE3/Qt3 and Qt4 cannot be used together in one project.")
  ELSE(KDE3_FIND_REQUIRED)
    IF(NOT KDE3_FIND_QUIETLY)
      MESSAGE( STATUS    "KDE3/Qt3 and Qt4 cannot be used together in one project.")
    ENDIF(NOT KDE3_FIND_QUIETLY)
    RETURN()
  ENDIF(KDE3_FIND_REQUIRED)
ENDIF(QT4_FOUND)


SET(QT_MT_REQUIRED TRUE)
#SET(QT_MIN_VERSION "3.0.0")

#this line includes FindQt.cmake, which searches the Qt library and headers
IF(KDE3_FIND_REQUIRED)
  SET(_REQ_STRING_KDE3 "REQUIRED")
ENDIF(KDE3_FIND_REQUIRED)
  
FIND_PACKAGE(Qt3 ${_REQ_STRING_KDE3})
FIND_PACKAGE(X11 ${_REQ_STRING_KDE3})


#now try to find some kde stuff
FIND_PROGRAM(KDECONFIG_EXECUTABLE NAMES kde-config
  HINTS
   $ENV{KDEDIR}/bin
   PATHS
  /opt/kde3/bin
  /opt/kde/bin
  /usr/kde3/bin
  )

SET(KDE3PREFIX)
IF(KDECONFIG_EXECUTABLE)
   EXECUTE_PROCESS(COMMAND ${KDECONFIG_EXECUTABLE} --version
                   OUTPUT_VARIABLE kde_config_version )

   STRING(REGEX MATCH "KDE: .\\." kde_version ${kde_config_version})
   IF (${kde_version} MATCHES "KDE: 3\\.")
      EXECUTE_PROCESS(COMMAND ${KDECONFIG_EXECUTABLE} --prefix
                        OUTPUT_VARIABLE kdedir )
      STRING(REGEX REPLACE "\n" "" KDE3PREFIX "${kdedir}")

    ENDIF (${kde_version} MATCHES "KDE: 3\\.")
ENDIF(KDECONFIG_EXECUTABLE)



# at first the KDE include direcory
# kpassdlg.h comes from kdeui and doesn't exist in KDE4 anymore
# FIND_PATH(KDE3_INCLUDE_DIR kpassdlg.h
#  HINTS
#  $ENV{KDEDIR}/include
#  ${KDE3PREFIX}/include
#  PATHS
#  /opt/kde3/include
#  /opt/kde/include
#  /usr/include/kde
#  /usr/local/include/kde
#  )

# override this
SET(KDE3_INCLUDE_DIR "/usr/include/kde")

#now the KDE library directory
FIND_LIBRARY(KDE3_KDECORE_LIBRARY NAMES kdecore
  HINTS
  $ENV{KDEDIR}/lib
  ${KDE3PREFIX}/lib
  PATHS
  /opt/kde3/lib
  /opt/kde/lib
  /usr/kde3/lib
)

SET(QT_AND_KDECORE_LIBS ${QT_LIBRARIES} ${KDE3_KDECORE_LIBRARY})

GET_FILENAME_COMPONENT(KDE3_LIB_DIR ${KDE3_KDECORE_LIBRARY} PATH )

IF(NOT KDE3_LIBTOOL_DIR)
   IF(KDE3_KDECORE_LIBRARY MATCHES lib64)
     SET(KDE3_LIBTOOL_DIR /lib64/kde3)
   ELSE(KDE3_KDECORE_LIBRARY MATCHES lib64)
     SET(KDE3_LIBTOOL_DIR /lib/kde3)
   ENDIF(KDE3_KDECORE_LIBRARY MATCHES lib64)
ENDIF(NOT KDE3_LIBTOOL_DIR)

#now search for the dcop utilities
FIND_PROGRAM(KDE3_DCOPIDL_EXECUTABLE NAMES dcopidl
  HINTS
  $ENV{KDEDIR}/bin
  ${KDE3PREFIX}/bin
  PATHS
  /opt/kde3/bin
  /opt/kde/bin
  /usr/kde3/bin
  )

FIND_PROGRAM(KDE3_DCOPIDL2CPP_EXECUTABLE NAMES dcopidl2cpp
  HINTS
  $ENV{KDEDIR}/bin
  ${KDE3PREFIX}/bin
  PATHS
  /opt/kde3/bin
  /opt/kde/bin
  /usr/kde3/bin
  )

FIND_PROGRAM(KDE3_KCFGC_EXECUTABLE NAMES kconfig_compiler
  HINTS
  $ENV{KDEDIR}/bin
  ${KDE3PREFIX}/bin
  PATHS
  /opt/kde3/bin
  /opt/kde/bin
  /usr/kde3/bin
  )


#SET KDE3_FOUND
IF (KDE3_INCLUDE_DIR AND KDE3_LIB_DIR AND KDE3_DCOPIDL_EXECUTABLE AND KDE3_DCOPIDL2CPP_EXECUTABLE AND KDE3_KCFGC_EXECUTABLE)
   SET(KDE3_FOUND TRUE)
ELSE (KDE3_INCLUDE_DIR AND KDE3_LIB_DIR AND KDE3_DCOPIDL_EXECUTABLE AND KDE3_DCOPIDL2CPP_EXECUTABLE AND KDE3_KCFGC_EXECUTABLE)
   SET(KDE3_FOUND FALSE)
ENDIF (KDE3_INCLUDE_DIR AND KDE3_LIB_DIR AND KDE3_DCOPIDL_EXECUTABLE AND KDE3_DCOPIDL2CPP_EXECUTABLE AND KDE3_KCFGC_EXECUTABLE)

# add some KDE specific stuff
SET(KDE3_DEFINITIONS -DQT_CLEAN_NAMESPACE -D_GNU_SOURCE)

# set compiler flags only if KDE3 has actually been found
IF(KDE3_FOUND)
   SET(_KDE3_USE_FLAGS FALSE)
   IF(CMAKE_COMPILER_IS_GNUCXX)
      SET(_KDE3_USE_FLAGS TRUE) # use flags for gnu compiler
      EXECUTE_PROCESS(COMMAND ${CMAKE_CXX_COMPILER} --version
                      OUTPUT_VARIABLE out)
      # gnu gcc 2.96 does not work with flags
      # I guess 2.95 also doesn't then
      IF("${out}" MATCHES "2.9[56]")
         SET(_KDE3_USE_FLAGS FALSE)
      ENDIF("${out}" MATCHES "2.9[56]")
   ENDIF(CMAKE_COMPILER_IS_GNUCXX)

   #only on linux, but NOT e.g. on FreeBSD:
   IF(CMAKE_SYSTEM_NAME MATCHES "Linux" AND _KDE3_USE_FLAGS)
      SET (KDE3_DEFINITIONS ${KDE3_DEFINITIONS} -D_XOPEN_SOURCE=500 -D_BSD_SOURCE)
      SET ( CMAKE_C_FLAGS     "${CMAKE_C_FLAGS} -Wno-long-long -ansi -Wundef -Wcast-align -Wconversion -Wchar-subscripts -Wall -W -Wpointer-arith -Wwrite-strings -Wformat-security -Wmissing-format-attribute -fno-common")
      SET ( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wnon-virtual-dtor -Wno-long-long -ansi -Wundef -Wcast-align -Wconversion -Wchar-subscripts -Wall -W -Wpointer-arith -Wwrite-strings -Wformat-security -fno-exceptions -fno-check-new -fno-common")
   ENDIF(CMAKE_SYSTEM_NAME MATCHES "Linux" AND _KDE3_USE_FLAGS)

   # works on FreeBSD, NOT tested on NetBSD and OpenBSD
   IF (CMAKE_SYSTEM_NAME MATCHES BSD AND _KDE3_USE_FLAGS)
      SET ( CMAKE_C_FLAGS     "${CMAKE_C_FLAGS} -Wno-long-long -ansi -Wundef -Wcast-align -Wconversion -Wchar-subscripts -Wall -W -Wpointer-arith -Wwrite-strings -Wformat-security -Wmissing-format-attribute -fno-common")
      SET ( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wnon-virtual-dtor -Wno-long-long -Wundef -Wcast-align -Wconversion -Wchar-subscripts -Wall -W -Wpointer-arith -Wwrite-strings -Wformat-security -Wmissing-format-attribute -fno-exceptions -fno-check-new -fno-common")
   ENDIF (CMAKE_SYSTEM_NAME MATCHES BSD AND _KDE3_USE_FLAGS)

   # if no special buildtype is selected, add -O2 as default optimization
   IF (NOT CMAKE_BUILD_TYPE AND _KDE3_USE_FLAGS)
      SET ( CMAKE_C_FLAGS     "${CMAKE_C_FLAGS} -O2")
      SET ( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -O2")
   ENDIF (NOT CMAKE_BUILD_TYPE AND _KDE3_USE_FLAGS)

#SET(CMAKE_SHARED_LINKER_FLAGS "-avoid-version -module -Wl,--no-undefined -Wl,--allow-shlib-undefined")
#SET(CMAKE_SHARED_LINKER_FLAGS "-Wl,--fatal-warnings -avoid-version -Wl,--no-undefined -lc")
#SET(CMAKE_MODULE_LINKER_FLAGS "-Wl,--fatal-warnings -avoid-version -Wl,--no-undefined -lc")
ENDIF(KDE3_FOUND)


# KDE3Macros.cmake contains all the KDE specific macros
INCLUDE(KDE3Macros)


MACRO (KDE3_PRINT_RESULTS)
   IF(KDE3_INCLUDE_DIR)
      MESSAGE(STATUS "Found KDE3 include dir: ${KDE3_INCLUDE_DIR}")
   ELSE(KDE3_INCLUDE_DIR)
      MESSAGE(STATUS "Didn't find KDE3 headers")
   ENDIF(KDE3_INCLUDE_DIR)

   IF(KDE3_LIB_DIR)
      MESSAGE(STATUS "Found KDE3 library dir: ${KDE3_LIB_DIR}")
   ELSE(KDE3_LIB_DIR)
      MESSAGE(STATUS "Didn't find KDE3 core library")
   ENDIF(KDE3_LIB_DIR)

   IF(KDE3_DCOPIDL_EXECUTABLE)
      MESSAGE(STATUS "Found KDE3 dcopidl preprocessor: ${KDE3_DCOPIDL_EXECUTABLE}")
   ELSE(KDE3_DCOPIDL_EXECUTABLE)
      MESSAGE(STATUS "Didn't find the KDE3 dcopidl preprocessor")
   ENDIF(KDE3_DCOPIDL_EXECUTABLE)

   IF(KDE3_DCOPIDL2CPP_EXECUTABLE)
      MESSAGE(STATUS "Found KDE3 dcopidl2cpp preprocessor: ${KDE3_DCOPIDL2CPP_EXECUTABLE}")
   ELSE(KDE3_DCOPIDL2CPP_EXECUTABLE)
      MESSAGE(STATUS "Didn't find the KDE3 dcopidl2cpp preprocessor")
   ENDIF(KDE3_DCOPIDL2CPP_EXECUTABLE)

   IF(KDE3_KCFGC_EXECUTABLE)
      MESSAGE(STATUS "Found KDE3 kconfig_compiler preprocessor: ${KDE3_KCFGC_EXECUTABLE}")
   ELSE(KDE3_KCFGC_EXECUTABLE)
      MESSAGE(STATUS "Didn't find the KDE3 kconfig_compiler preprocessor")
   ENDIF(KDE3_KCFGC_EXECUTABLE)

ENDMACRO (KDE3_PRINT_RESULTS)


IF (KDE3_FIND_REQUIRED AND NOT KDE3_FOUND)
   #bail out if something wasn't found
   KDE3_PRINT_RESULTS()
   MESSAGE(FATAL_ERROR "Could NOT find everything required for compiling KDE 3 programs")

ENDIF (KDE3_FIND_REQUIRED AND NOT KDE3_FOUND)


IF (NOT KDE3_FIND_QUIETLY)
   KDE3_PRINT_RESULTS()
ENDIF (NOT KDE3_FIND_QUIETLY)

#add the found Qt and KDE include directories to the current include path
SET(KDE3_INCLUDE_DIRS ${QT_INCLUDE_DIR} ${KDE3_INCLUDE_DIR})

include(kdesvnMacros)

IF(CMAKE_SIZEOF_VOID_P EQUAL 4)
  SET(DEF_SUFF "")
ELSE(CMAKE_SIZEOF_VOID_P EQUAL 4)
  SET(DEF_SUFF 64)
ENDIF(CMAKE_SIZEOF_VOID_P EQUAL 4)

set(LIB_SUFFIX ${DEF_SUFF} CACHE STRING "Define suffix of directory name (32/64)" FORCE)

SET(LIB_SEARCH_PATHES   ${KDE3_LIB_DIR}
  $ENV{KDEDIR}/lib
  /opt/kde/lib
  /opt/kde3/lib
  /usr/lib
  /usr/local/lib
  /usr/kde3/lib
)

IF (LIB_SUFFIX)
    SET(LIB_SEARCH_PATHES
        $ENV{KDEDIR}/lib${LIB_SUFFIX}
        /opt/kde/lib${LIB_SUFFIX}
        /opt/kde3/lib${LIB_SUFFIX}
        /usr/lib${LIB_SUFFIX}
        /usr/local/lib${LIB_SUFFIX}
        ${LIB_SEARCH_PATHES})
ENDIF (LIB_SUFFIX)

FIND_LIBRARY(KDE3_UI_LIBRARY NAMES kdeui
  PATHS
  ${LIB_SEARCH_PATHES}
)

FIND_LIBRARY(KDE3_PART_LIBRARY NAMES kparts
  PATHS
  ${LIB_SEARCH_PATHES}
)

FIND_LIBRARY(KDE3_KIO_LIBRARY NAMES kio
  PATHS
  ${LIB_SEARCH_PATHES}
)

FIND_LIBRARY(KDE3_DCOP_LIBRARY NAMES DCOP
  PATHS
  ${LIB_SEARCH_PATHES}
)

FIND_LIBRARY(KDE3_WALLET_LIBRARY NAMES kwalletclient
  PATHS
  ${LIB_SEARCH_PATHES}
)

FIND_LIBRARY(KDE3_KINIT_KDED_LIBRARY NAMES kdeinit_kded
  PATHS
  ${LIB_SEARCH_PATHES}
)

FIND_PROGRAM(KDE3_KDECONFIG_EXECUTABLE NAME kde-config PATHS
    $ENV{KDEDIR}/bin
    /opt/kde/bin
    /opt/kde3/bin
    /usr/kde3/bin
)

FIND_PROGRAM(MSGFMT
    NAMES gmsgfmt msgfmt)

FIND_PROGRAM(STRIP
    NAMES strip)

FIND_PROGRAM(KDE3_MEINPROC_EXECUTABLE NAME meinproc PATHS
     ${KDE3_BIN_INSTALL_DIR}
     $ENV{KDEDIR}/bin
     /opt/kde/bin
     /opt/kde3/bin
     /usr/kde3/bin
)

IF(KDE3_MEINPROC_EXECUTABLE)
    MESSAGE(STATUS "Found meinproc: ${KDE3_MEINPROC_EXECUTABLE}")
ELSE(KDE3_MEINPROC_EXECUTABLE)
    MESSAGE(STATUS "Didn't find meinproc!")
ENDIF(KDE3_MEINPROC_EXECUTABLE)

IF(MSGFMT)
    EXECUTE_PROCESS(COMMAND ${MSGFMT} "--version" "2>&1"
    OUTPUT_VARIABLE _msgout)
    STRING(REGEX MATCH "GNU[\t ]gettext" _isgnu "${_msgout}")
    IF (NOT _isgnu)
        MESSAGE(STATUS "No gnu msgfmt found!")
        SET(MSGFMT ":" CACHE STRING "Msgfmt program")
    ELSE(NOT _isgnu)
        MESSAGE(STATUS "Found gnu msgfmt: ${MSGFMT}")
    ENDIF (NOT _isgnu)
ELSE(MSGFMT)
    SET(MSGFMT ":" CACHE STRING "Msgfmt program")
ENDIF(MSGFMT)

# 'cause my own defines were not good I take them from kde4 trunk
#add some KDE specific stuff
set(SHARE_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX}/share CACHE PATH "Base directory for files which go to share/" FORCE)
set(EXEC_INSTALL_PREFIX  ${CMAKE_INSTALL_PREFIX}       CACHE PATH  "Base directory for executables and libraries" FORCE)
#
## the following are directories where stuff will be installed to
set(BIN_INSTALL_DIR          "${EXEC_INSTALL_PREFIX}/bin"                  CACHE PATH "The kde bin install dir (default prefix/bin)" FORCE)
set(SBIN_INSTALL_DIR         "${EXEC_INSTALL_PREFIX}/sbin"                 CACHE PATH "The kde sbin install dir (default prefix/sbin)" FORCE)
set(LIB_INSTALL_DIR          "${EXEC_INSTALL_PREFIX}/lib${LIB_SUFFIX}"     CACHE PATH "The subdirectory relative to the install prefix where libraries will be installed (default is /lib${LIB_SUFFIX})" FORCE)
set(LIBEXEC_INSTALL_DIR      "${LIB_INSTALL_DIR}/kde3/libexec"             CACHE PATH "The subdirectory relative to the install prefix where libraries will be installed (default is /lib/kde3/libexec)" FORCE)
set(PLUGIN_INSTALL_DIR       "${LIB_INSTALL_DIR}/kde3"                     CACHE PATH "The subdirectory relative to the install prefix where plugins will be installed (default is ${LIB_INSTALL_DIR}/kde3)" FORCE)
set(INCLUDE_INSTALL_DIR      "${CMAKE_INSTALL_PREFIX}/include"             CACHE PATH "The subdirectory to the header prefix" FORCE)
set(CONFIG_INSTALL_DIR       "${SHARE_INSTALL_PREFIX}/config"              CACHE PATH "The config file install dir" FORCE)
set(DATA_INSTALL_DIR         "${SHARE_INSTALL_PREFIX}/apps"                CACHE PATH "The parent directory where applications can install their data" FORCE)
set(HTML_INSTALL_DIR         "${SHARE_INSTALL_PREFIX}/doc/HTML"            CACHE PATH "The HTML install dir for documentation"  FORCE)
set(ICON_INSTALL_DIR         "${SHARE_INSTALL_PREFIX}/icons"               CACHE PATH "The icon install dir (default prefix/share/icons/)" FORCE)
set(KCFG_INSTALL_DIR         "${SHARE_INSTALL_PREFIX}/config.kcfg"         CACHE PATH "The install dir for kconfig files" FORCE)
set(LOCALE_INSTALL_DIR       "${SHARE_INSTALL_PREFIX}/locale"              CACHE PATH "The install dir for translations" FORCE)
set(MIME_INSTALL_DIR         "${SHARE_INSTALL_PREFIX}/mimelnk"             CACHE PATH "The install dir for the mimetype desktop files" FORCE)
set(SERVICES_INSTALL_DIR     "${SHARE_INSTALL_PREFIX}/services"            CACHE PATH "The install dir for service (desktop, protocol, ...) files" FORCE)
set(SERVICETYPES_INSTALL_DIR "${SHARE_INSTALL_PREFIX}/servicetypes"        CACHE PATH "The install dir for servicestypes desktop files" FORCE)
set(SOUND_INSTALL_DIR        "${SHARE_INSTALL_PREFIX}/sounds"              CACHE PATH "The install dir for sound files" FORCE)
set(TEMPLATES_INSTALL_DIR    "${SHARE_INSTALL_PREFIX}/templates"           CACHE PATH "The install dir for templates (Create new file...)" FORCE)
set(WALLPAPER_INSTALL_DIR    "${SHARE_INSTALL_PREFIX}/wallpapers"          CACHE PATH "The install dir for wallpapers" FORCE)
set(KCONF_UPDATE_INSTALL_DIR "${DATA_INSTALL_DIR}/kconf_update"            CACHE PATH "The kconf_update install dir" FORCE)
# this one shouldn't be used anymore
set(APPLNK_INSTALL_DIR       "${SHARE_INSTALL_PREFIX}/applnk"              CACHE PATH "Is this still used ?" FORCE)
set(AUTOSTART_INSTALL_DIR    "${SHARE_INSTALL_PREFIX}/autostart"           CACHE PATH "The install dir for autostart files" FORCE)
set(XDG_APPS_DIR             "${SHARE_INSTALL_PREFIX}/applications/kde"    CACHE PATH "The XDG apps dir" FORCE)
set(XDG_DIRECTORY_DIR        "${SHARE_INSTALL_PREFIX}/desktop-directories" CACHE PATH "The XDG directory" FORCE)
set(SYSCONF_INSTALL_DIR      "${CMAKE_INSTALL_PREFIX}/etc"                 CACHE PATH "The kde sysconfig install dir (default/etc)" FORCE)
set(MAN_INSTALL_DIR          "${SHARE_INSTALL_PREFIX}/man"                 CACHE PATH "The kde man install dir (default prefix/share/man/)" FORCE)
set(INFO_INSTALL_DIR         "${CMAKE_INSTALL_PREFIX}/info"                CACHE PATH "The kde info install dir (default prefix/info)" FORCE)

# linker flags - must get checked

IF (CMAKE_SYSTEM MATCHES "Linux*")
    SET(lundef "-Wl,--no-undefined")
    KDESVN_CHECK_LINK_FLAG(${lundef} _NO_UNDEFINED)
    IF (_NO_UNDEFINED)
        SET(LINK_NO_UNDEFINED "${lundef}")
    ENDIF (_NO_UNDEFINED)

    SET(lundef "-Wl,--allow-shlib-undefined")
    KDESVN_CHECK_LINK_FLAG(${lundef} _ALLOW_SHLIB)
    IF (_ALLOW_SHLIB)
        SET(LINK_NO_UNDEFINED "${LINK_NO_UNDEFINED} ${lundef}")
    ENDIF (_ALLOW_SHLIB)
ENDIF (CMAKE_SYSTEM MATCHES "Linux*")


# own macros
MACRO(KDESVN_INSTALL_ICONS _theme)

   FILE(GLOB _icons *.png)
   FILE(GLOB _svg *svgz)
   SET(_icons ${_icons} ${_svg})
   FOREACH(_current_ICON ${_icons} )
      GET_FILENAME_COMPONENT(_ctype ${_current_ICON} EXT)

	  if (${_ctype} STREQUAL ".png")
      STRING(REGEX REPLACE "^.*/[a-zA-Z]+([0-9]+)\\-([a-z]+)\\-(.+\\.png)$" "\\1" _size "${_current_ICON}")
      STRING(REGEX REPLACE "^.*/[a-zA-Z]+([0-9]+)\\-([a-z]+)\\-(.+\\.png)$" "\\2" _group "${_current_ICON}")
      STRING(REGEX REPLACE "^.*/[a-zA-Z]+([0-9]+)\\-([a-z]+)\\-(.+\\.png)$" "\\3" _name "${_current_ICON}")
	  set(_sizestring "${_size}x${_size}")
	  endif (${_ctype} STREQUAL ".png")

	  if (${_ctype} STREQUAL ".svgz")
        STRING(REGEX REPLACE "^.*/[a-zA-Z]+\\-([a-z]+)\\-(.+\\.svgz)$" "\\1" _group "${_current_ICON}")
        STRING(REGEX REPLACE "^.*/[a-zA-Z]+\\-([a-z]+)\\-(.+\\.svgz)$" "\\2" _name "${_current_ICON}")
		set(_sizestring "scalable")
	  endif (${_ctype} STREQUAL ".svgz")

      SET(_icon_GROUP "actions")

      IF(${_group} STREQUAL "mime")
         SET(_icon_GROUP  "mimetypes")
      ENDIF(${_group} STREQUAL "mime")

      IF(${_group} STREQUAL "filesys")
         SET(_icon_GROUP  "filesystems")
      ENDIF(${_group} STREQUAL "filesys")

      IF(${_group} STREQUAL "device")
         SET(_icon_GROUP  "devices")
      ENDIF(${_group} STREQUAL "device")

      IF(${_group} STREQUAL "app")
         SET(_icon_GROUP  "apps")
      ENDIF(${_group} STREQUAL "app")

      IF(${_group} STREQUAL "action")
         SET(_icon_GROUP  "actions")
      ENDIF(${_group} STREQUAL "action")

      #message(STATUS "icon: ${_current_ICON} size: ${_sizestring} group: ${_group} name: ${_name}" )
      SET(_ICON_INSTALL_DIR ${ICON_INSTALL_DIR}/${_theme}/${_sizestring}/${_icon_GROUP})

      INSTALL(FILES ${_current_ICON} DESTINATION ${_ICON_INSTALL_DIR} RENAME ${_name})

   ENDFOREACH (_current_ICON)
ENDMACRO(KDESVN_INSTALL_ICONS)

MACRO(ADD_POFILES packagename)
    SET(_gmofiles)
    FILE(GLOB _pofiles *.po)

    FOREACH(_current_po ${_pofiles})
        GET_FILENAME_COMPONENT(_name ${_current_po} NAME_WE)
        STRING(REGEX REPLACE "^.*/([a-zA-Z]+)(\\.po)" "\\1" _lang "${_current_po}")
        SET(_gmofile "${CMAKE_CURRENT_BINARY_DIR}/${_name}.gmo")
        ADD_CUSTOM_COMMAND(OUTPUT ${_gmofile}
            COMMAND ${MSGFMT}
            ARGS "-o" "${_gmofile}" "${_current_po}"
            DEPENDS ${_current_po}
            )
        SET(_gmofiles ${_gmofiles} ${_gmofile})
        INSTALL(FILES ${_gmofile}
            DESTINATION ${LOCALE_INSTALL_DIR}/${_lang}/LC_MESSAGES
            RENAME ${packagename}.mo)
    ENDFOREACH(_current_po ${_pofiles})

    ADD_CUSTOM_TARGET(translations ALL
        DEPENDS ${_gmofiles})

ENDMACRO(ADD_POFILES)
