/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PROGRAMCATALOG_H
#define PROGRAMCATALOG_H

#include <kgenericfactory.h>

#include <qptrlist.h>
#include <qstring.h>

#include "cachedcatalog.h"

class QWidget;

/**
@author Joe Ferris
*/
class ProgramCatalog : public CachedCatalog
{
	Q_OBJECT
public:
	ProgramCatalog(QObject *, const char *, const QStringList&);
	virtual ~ProgramCatalog();

	virtual void initialize();	
	virtual void readSettings(KConfigBase *);
	virtual void writeSettings(KConfigBase *);
	virtual unsigned int minQueryLen() const;
	virtual QWidget * configure();
	
public slots:
	void minQueryLenChanged(int);
	void toggleIgnoreIconless(bool);
	void toggleUseExecName(bool);
	void toggleIgnoreTerminal(bool);
	
private:
	void cacheProgramList(QString);
	int _minQueryLen;
	bool _ignoreIconless;
	bool _useExecName;
	bool _ignoreTerminal;
};

#endif
