/***************************************************************************
 *   Copyright (C) 2007  Martin Meredith                                   *
 *   mez@ubuntu.com                                                        *
 *                                                                         *
 *   Copyright (C) 2006  Jonathan Riddell                                  *
 *   jriddell@ubuntu.com                                                   *
 *                                                                         *
 *   Copyright (C) 2005  Tobi Vollebregt                                   *
 *   tobivollebregt@gmail.com                                              *
 *                                                                         *
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef GOOGLECATALOG_H
#define GOOGLECATALOG_H

#include <kgenericfactory.h>

#include <qstring.h>

#include "query.h"
#include "katapultcatalog.h"

class QWidget;

/**
@author Jonathan Riddell
 */
class GoogleCatalog : public KatapultCatalog
{
	Q_OBJECT

	public:

		GoogleCatalog(QObject*, const char*, const QStringList&);
		virtual ~GoogleCatalog();

		virtual void readSettings(KConfigBase*);
		virtual void writeSettings(KConfigBase*);
		virtual QWidget* configure();
		int triggerWordLength();

	protected:

		virtual void queryChanged();

	 private:
		bool accepts(const QString&) const;

		QString _triggerWord;

		SearchQuery _result; // The one result (there's always one).

		void reset();

        protected slots:
		void triggerWordChanged(const QString& triggerWord);

};

#endif
