// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for KDE
Copyright 2000-2004 Aurlien Gteau
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef EXTERNALTOOLMANAGER_H
#define EXTERNALTOOLMANAGER_H

// Qt
#include <qdict.h>
#include <qptrlist.h>

// KDE
#include <kfileitem.h>

// Local
#include "libgwenview_export.h"

class KActionMenu;
class KURL;

namespace Gwenview {
class ExternalToolContext;
class ExternalToolManagerPrivate;

class LIBGWENVIEW_EXPORT ExternalToolManager {
public:
	~ExternalToolManager();
	
	ExternalToolContext* createContext(QObject* parent, const KFileItemList*);
	ExternalToolContext* createContext(QObject* parent, const KURL&);

	static ExternalToolManager* instance();
	QDict<KDesktopFile>& desktopFiles() const;

	void hideDesktopFile(KDesktopFile*);
	
	// Create a new desktop file
	KDesktopFile* createUserDesktopFile(const QString& name);

	// Create a desktop file based on a existing (system) desktop file
	KDesktopFile* editSystemDesktopFile(const KDesktopFile* desktopFile);
	void updateServices();

private:
	ExternalToolManager();
	ExternalToolManagerPrivate* d;
};

} // namespace
#endif

