// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for KDE
Copyright 2000-2004 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef EXTERNALTOOLDIALOG_H 
#define EXTERNALTOOLDIALOG_H

// KDE
#include <kdialogbase.h>

// Our includes
#include "libgwenview_export.h"

namespace Gwenview {


class ExternalToolDialogPrivate;
class LIBGWENVIEW_EXPORT ExternalToolDialog : public KDialogBase {
Q_OBJECT
public:
	ExternalToolDialog(QWidget* parent);
	~ExternalToolDialog();
	
protected slots:
	void slotOk();
	void slotApply();
	void slotCancel();

private slots:
	void slotSelectionChanged(QListViewItem*);
	void addTool();
	void deleteTool();
	void showCommandHelp();
	void openURL(const QString& url);
	
private:
	ExternalToolDialogPrivate* d;
};


} // namespace
#endif

