//=============================================================================
//
//   File : notifiermessage.cpp
//   Created on mar 02 nov 2004 02:41:18 by Iacopo
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2004 Iacopo <iakko@siena.linux.it>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "notifiermessage.h"
#include "notifierwindow.h"

#include "kvi_iconmanager.h"
#include "kvi_config.h"
#include "kvi_app.h"
#include "kvi_window.h"

#include "kvi_locale.h"
#include "kvi_frame.h"
#include "kvi_mirccntrl.h"
#include "kvi_options.h"

/*
#ifdef COMPILE_ON_WINDOWS
	#include <windows.h>
#endif

#ifdef COMPILE_KDE_SUPPORT
	#include <netwm.h>
#endif
*/

#include <qapplication.h>
#include <qpainter.h>
#include <qimage.h>
#include <qdesktopwidget.h>
#include <qtooltip.h>

#ifdef COMPILE_USE_QT4
	#define QPopupMenu Q3PopupMenu
	#include <q3popupmenu.h>
#else
	#include <qpopupmenu.h>
#endif

extern kvi_time_t g_tNotifierDisabledUntil;

KviNotifierMessage::KviNotifierMessage(KviNotifierWindow * pNotifierWindow, QPixmap * pImage, const QString &szText)
{
	m_pText = new QSimpleRichText(KviMircCntrl::stripControlBytes(szText),pNotifierWindow->defaultFont());
	m_pText->setWidth(pNotifierWindow->textWidth());
	m_pImage = pImage;
	m_bHistoric = false;
}

KviNotifierMessage::~KviNotifierMessage()
{
	delete m_pText;
	if(m_pImage)delete m_pImage;
}

static void increase_transparency(QImage &buffer,QImage &srcimg,int iDivisor)
{
	buffer.create(srcimg.width(),srcimg.height(),32);
	buffer.setAlphaBuffer(true);

	for(int y = 0;y < buffer.height();y++)
	{
		QRgb * dst = (QRgb *)buffer.scanLine(y);
		QRgb * end = dst + buffer.width();
		QRgb * src = (QRgb *)srcimg.scanLine(y);

		while(dst < end)
		{
			*dst = qRgba(qRed(*src),qGreen(*src),qBlue(*src),qAlpha(*src) / iDivisor);
			dst++;
			src++;
		}
	}
}

void KviNotifierMessage::setHistoric()
{
	m_bHistoric = true;
	if(!m_pImage)return;
	if(!m_pImage->hasAlphaChannel())return;
	QImage tmp;
	QImage out = m_pImage->convertToImage();
	increase_transparency(tmp,out,2);
	m_pImage->convertFromImage(tmp);
}

