//=============================================================================
//
//   File : kvi_kvs_treenode_scopeoperator.cpp
//   Created on Tue 07 Oct 2003 02:33:01 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_treenode_scopeoperator.h"

#include "kvi_qstring.h"

#include "kvi_kvs_variant.h"
#include "kvi_kvs_runtimecontext.h"
#include "kvi_kvs_kernel.h"
#include "kvi_kvs_object.h"
#include "kvi_kvs_object_controller.h"

#include "kvi_locale.h"

KviKvsTreeNodeScopeOperator::KviKvsTreeNodeScopeOperator(const QChar * pLocation,KviKvsTreeNodeData * pObject,KviKvsTreeNodeData * pData)
: KviKvsTreeNodeData(pLocation)
{
	m_pObjectReference = pObject;
	m_pObjectReference->setParent(this);
	m_pRightSide = pData;
	m_pRightSide->setParent(this);
}

KviKvsTreeNodeScopeOperator::~KviKvsTreeNodeScopeOperator()
{
	delete m_pObjectReference;
	delete m_pRightSide;
}

void KviKvsTreeNodeScopeOperator::contextDescription(QString &szBuffer)
{
	szBuffer = "Scope Operator";
}


void KviKvsTreeNodeScopeOperator::dump(const char * prefix)
{
	debug("%s ScopeOperator",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	m_pObjectReference->dump(tmp.utf8().data());
	m_pRightSide->dump(tmp.utf8().data());
}

bool KviKvsTreeNodeScopeOperator::isReadOnly()
{
	return m_pRightSide->isReadOnly();
}

bool KviKvsTreeNodeScopeOperator::canEvaluateToObjectReference()
{
	return m_pRightSide->canEvaluateToObjectReference();
}

bool KviKvsTreeNodeScopeOperator::isFunctionCall()
{
	return m_pRightSide->isFunctionCall();
}

bool KviKvsTreeNodeScopeOperator::canEvaluateInObjectScope()
{
	return m_pObjectReference->canEvaluateInObjectScope();
}

KviKvsObject * KviKvsTreeNodeScopeOperator::objectFromVariant(KviKvsRunTimeContext * c,KviKvsVariant * v)
{
	kvs_hobject_t hObject;
	if(!v->asHObject(hObject))
	{
		c->error(this,__tr2qs("The left side of the scope operator didn't evaluate as an object reference"));
		return 0;
	}

	if(hObject == (kvs_hobject_t)0)
	{
		c->error(this,__tr2qs("The left side of the scope operator evaluated to a null object reference"));
		return 0;
	}

	KviKvsObject * o = KviKvsKernel::instance()->objectController()->lookupObject(hObject);
	if(!o)
	{
		c->error(this,__tr2qs("The left side of the scope operator evaluated to an invalid object reference (object doesn't exist)"));
		return 0;
	}
	return o;
}

bool KviKvsTreeNodeScopeOperator::evaluateReadOnly(KviKvsRunTimeContext * c,KviKvsVariant * pBuffer)
{
	KviKvsVariant ret;
	if(!m_pObjectReference->evaluateReadOnly(c,&ret))return false;
	KviKvsObject * o = objectFromVariant(c,&ret);
	if(!o)return false;
	return m_pRightSide->evaluateReadOnlyInObjectScope(o,c,pBuffer);
}

KviKvsRWEvaluationResult * KviKvsTreeNodeScopeOperator::evaluateReadWrite(KviKvsRunTimeContext * c)
{
	KviKvsVariant ret;
	if(!m_pObjectReference->evaluateReadOnly(c,&ret))return 0;
	KviKvsObject * o = objectFromVariant(c,&ret);
	if(!o)return 0;
	return m_pRightSide->evaluateReadWriteInObjectScope(o,c);
}

bool KviKvsTreeNodeScopeOperator::evaluateReadOnlyInObjectScope(KviKvsObject * o,KviKvsRunTimeContext * c,KviKvsVariant * pBuffer)
{
	KviKvsVariant ret;
	if(!m_pObjectReference->evaluateReadOnlyInObjectScope(o,c,&ret))return false;
	KviKvsObject * pObject = objectFromVariant(c,&ret);
	if(!pObject)return false;
	return m_pRightSide->evaluateReadOnlyInObjectScope(pObject,c,pBuffer);
}

KviKvsRWEvaluationResult * KviKvsTreeNodeScopeOperator::evaluateReadWriteInObjectScope(KviKvsObject * o,KviKvsRunTimeContext * c)
{
	KviKvsVariant ret;
	if(!m_pObjectReference->evaluateReadOnlyInObjectScope(o,c,&ret))return 0;
	KviKvsObject * pObject = objectFromVariant(c,&ret);
	if(!pObject)return 0;
	return m_pRightSide->evaluateReadWriteInObjectScope(pObject,c);
}

