/**
 * MltConsumer.h - MLT Wrapper
 * Copyright (C) 2004-2005 Charles Yates
 * Author: Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _MLTPP_CONSUMER_H_
#define _MLTPP_CONSUMER_H_

#include "config.h"

#include <framework/mlt.h>

#include "MltService.h"

namespace Mlt
{
	class Service;

	class MLTPP_DECLSPEC Consumer : public Service
	{
		private:
			mlt_consumer instance;
		public:
			Consumer( );
			Consumer( char *id , char *service = NULL );
			Consumer( Service &consumer );
			Consumer( Consumer &consumer );
			Consumer( mlt_consumer consumer );
			virtual ~Consumer( );
			virtual mlt_consumer get_consumer( );
			mlt_service get_service( );
			virtual int connect( Service &service );
			int run( );
			int start( );
			void purge( );
			int stop( );
			bool is_stopped( );
	};
}

#endif
