/***************************************************************************
                          pgn.h  -  description
                             -------------------
    begin                : Mon Jul 30 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PGN_H
#define PGN_H

#include <klocale.h>
#include <ktempfile.h>
#include <kio/netaccess.h>
#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qpainter.h>
#include "definitions.h"
#include "resource.h"
#include "knightsmap.h"
#include "match_param.h"

/**
  *@author Troy Corbin Jr.
  */

typedef struct Annotation
{
	int RAV;
	QString text;
};

typedef QValueList<ChessMove> MoveList;
typedef KnightsMap<int, Annotation*> Annotations;

class tab_pgnView;

class pgn : public QObject
{
	Q_OBJECT
	public:
		/* Standard PGN Tags */
		QString 						TAG_Event;
		QString 						TAG_Site;
		QString 						TAG_Date;
		QString 						TAG_Round;
		QString 						TAG_White;
		QString 						TAG_Black;
		QString 						TAG_Result;
		QString 						TAG_EventDate;
		QString 						TAG_EventSponsor;
		QString 						TAG_Section;
		QString 						TAG_Stage;
		QString 						TAG_Board;
		QString 						TAG_WhiteTitle;
		QString 						TAG_WhiteElo;
		QString 						TAG_WhiteUSCF;
		QString 						TAG_WhiteNA;
		QString 						TAG_WhiteType;
		QString 						TAG_BlackTitle;
		QString 						TAG_BlackElo;
		QString 						TAG_BlackUSCF;
		QString 						TAG_BlackNA;
		QString 						TAG_BlackType;
		QString 						TAG_Opening;
		QString 						TAG_Variation;
		QString 						TAG_SubVariation;
		QString 						TAG_ECO;
		QString 						TAG_NIC;
		QString 						TAG_Time;
		QString 						TAG_UTCTime;
		QString 						TAG_UTCDate;
		QString 						TAG_TimeControl;
		QString 						TAG_SetUp;
		QString 						TAG_FEN;
		QString							TAG_Termination;
		QString							TAG_Annotator;
		QString							TAG_Mode;
		QString 						TAG_PlyCount;

		int									File_Position; // Used to scan PGN file
		QStringList					Move_Data;

		/* The match_param */
		match_param					*Param;

												/* These are used in unfinished save games */
		int									whiteTime;
		int									blackTime;
		TCPList							whiteTCP;
		TCPList							blackTCP;

		QString							CurrentURL;
		MoveList						Moves;
		Annotations					RAV;
		Annotations					annotations;
		QStringList					Positions;
		unsigned int				currentIndex;

												pgn( resource *Rsrc=0, match_param *param=NULL );
												~pgn();
		void								clear( void );
		void								init( void );
		int									scan( void );
		bool								load( const int pos=0 );
		bool								save( QString URL );
		bool								open( const QString& URL );
		void								print( void );
		QStringList*				notation( const int format=1 );
		void								close( void );
		static QString			getNAG( int num );
		QString							caption( void );

	signals:
		void								processMove( ChessMove );
		void								processSpecial( void );

	public slots:
		bool								loadNext( void );
		void								parseMatchParam( void );
		void								childViewDestroyed( void );

	private:
		resource						*Resource;
		tab_pgnView					*pgnView;
		QString							tempFile;
		QString							currentLine;
		QFile								File;
		QTextStream					Input;

		QChar								getch( void );
		QString							getword( void );
		void								clearTags( void );
		void								parseTag( void );
		void								parseAnnotation( const int fromRAVnum=0 );
		void								parseRAV( void );
		void								parseKnightsData( void );
};

#endif
