/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  This class contains functions that interact with kaddressbook.
  begin:     Fri 2004-07-23
  copyright: (C) 2004 by John Tapsell
  email:     john@geola.co.uk
*/

#ifndef ADDRESSBOOK_H
#define ADDRESSBOOK_H

#include <kabc/addressbook.h>
#include <kabc/stdaddressbook.h>

#include <kstaticdeleter.h>
#include <tqobject.h>
#include <tqregexp.h>
#include <config.h>
#include "kimiface.h"

#include "../images.h"
#include "../nickinfo.h"
#include "addressbook_base.h"

namespace Konversation
{
    class Addressbook : public AddressbookBase
    {
        Q_OBJECT
            public:

            virtual ~Addressbook();               // This needs to be public so it can be deleted by our static pointer
            static Addressbook *self();
            TQStringList allContactsNicks();
            TQStringList allContacts();
            TQStringList reachableContacts();
            TQStringList onlineContacts();
            TQStringList fileTransferContacts();
            bool isPresent( const TQString &uid );
            TQString displayName( const TQString &uid );
            TQString presenceString( const TQString &uid );
            bool canReceiveFiles( const TQString &uid );
            bool canRespond( const TQString &uid );
            TQString locate( const TQString &contactId, const TQString &protocol );
            // metadata
            TQPixmap icon( const TQString &uid );
            TQString context( const TQString &uid );
            virtual int presenceStatus(const TQString &uid);
            // App capabilities
            TQStringList protocols();

            /**
             * Message a contact by their metaContactId, aka their uid in KABC.
             */
            void messageContact( const TQString &uid, const TQString& message );

            /**
             * Open a chat to a contact, and optionally set some initial text
             */
            void messageNewContact(  const TQString &contactId, const TQString &protocolId );

            /**
             * Message a contact by their metaContactId, aka their uid in KABC.
             */
            void chatWithContact( const TQString &uid );

            /**
             * Send the file to the contact
             */
            void sendFile(const TQString &uid, const KURL &sourceURL,
                const TQString &altFileName = TQString(), uint fileSize = 0);

            /**
             * Lets outsiders tell us to emit presenceChanged signal.
             */
            void emitContactPresenceChanged( const TQString &uid, int presence);
            /**
             * Lets outsiders tell us to emit presenceChanged signal.
             */
            void emitContactPresenceChanged(const TQString &uid);

            bool addContact( const TQString &contactId, const TQString &protocolId );

        protected:
            Addressbook();

            static Addressbook *m_instance;
    };

    static KStaticDeleter<Addressbook> sd;

}
#endif
