/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  The konversation DCOP interface class
  begin:     Mar 7 2003
  copyright: (C) 2003 by Alex Zepeda
  email:     zipzippy@sonic.net
*/

#ifndef KONV_DCOP_H
#define KONV_DCOP_H

#include "konviface.h"
#include "common.h"

#include <tqobject.h>
#include <dcopobject.h>


class KonvDCOP : public TQObject, virtual public KonvIface
{
    Q_OBJECT

    public:
        KonvDCOP();

        TQString getNickname (const TQString &server);
        TQString getAnyNickname ();
        TQString getChannelEncoding(const TQString& server, const TQString& channel);

    signals:
        void dcopSay(const TQString& server,const TQString& target,const TQString& command);
        void dcopInfo(const TQString& string);
        void dcopInsertMarkerLine();
        void dcopRaw(const TQString& server, const TQString& command);
        void dcopMultiServerRaw(const TQString& command);

        void connectTo(Konversation::ConnectionFlag flag,
                       const TQString& hostName,
                       const TQString& port = "",
                       const TQString& password = "",
                       const TQString& nick = "",
                       const TQString& channel = "",
                       bool useSSL = false);

    public slots:
        void setAway(const TQString &awaymessage);
        void setBack();
        void sayToAll(const TQString &message);
        void actionToAll(const TQString &message);
        void raw(const TQString& server,const TQString& command);
        void say(const TQString& server,const TQString& target,const TQString& command);
        void info(const TQString& string);
        void debug(const TQString& string);
        void error(const TQString& string);
        void insertMarkerLine();
        void connectToServer(const TQString& adress, int port, const TQString& channel, const TQString& password);
        TQStringList listServers();
        TQStringList listConnectedServers();

        void setScreenSaverStarted();
        void setScreenSaverStopped();
};

class KonvIdentDCOP : public TQObject, virtual public KonvIdentityIface
{
    Q_OBJECT

        public:
        KonvIdentDCOP();

        void setrealName(const TQString &identity, const TQString& name);
        TQString getrealName(const TQString &identity);
        void setIdent(const TQString &identity, const TQString& ident);
        TQString getIdent(const TQString &identity);

        void setNickname(const TQString &identity, int index,const TQString& nick);
        TQString getNickname(const TQString &identity, int index);

        void setBot(const TQString &identity, const TQString& bot);
        TQString getBot(const TQString &identity);
        void setPassword(const TQString &identity, const TQString& password);
        TQString getPassword(const TQString &identity);

        void setNicknameList(const TQString &identity, const TQStringList& newList);
        TQStringList getNicknameList(const TQString &identity);

        void setQuitReason(const TQString &identity, const TQString& reason);
        TQString getQuitReason(const TQString &identity);
        void setPartReason(const TQString &identity, const TQString& reason);
        TQString getPartReason(const TQString &identity);
        void setKickReason(const TQString &identity, const TQString& reason);
        TQString getKickReason(const TQString &identity);

        void setShowAwayMessage(const TQString &identity, bool state);
        bool getShowAwayMessage(const TQString &identity);

        void setAwayMessage(const TQString &identity, const TQString& message);
        TQString getAwayMessage(const TQString &identity);
        void setReturnMessage(const TQString &identity, const TQString& message);
        TQString getReturnMessage(const TQString &identity);

        TQStringList listIdentities();
};
#endif
