/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2002 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2005-2006 Eike Hein <hein@kde.org>
*/

#ifndef IMAGES_H
#define IMAGES_H

#include <tqiconset.h>
#include <tqpixmap.h>
#include <tqobject.h>


/**
 * Do not create an instance of this class yourself.
 * use KonversationApplication::instance()->images().
 */

class Images : public QObject
{
    Q_OBJECT

    public:
        enum NickPrivilege
        {
            Normal=0,
            Voice,
            HalfOp,
            Op,
            Owner,
            Admin,
            _NickPrivilege_COUNT
        };

        Images();
        virtual ~Images();

        TQPixmap getCloseIcon() { return m_closeIcon; }
        TQPixmap getDisabledCloseIcon() { return m_disabledCloseIcon; }

        TQIconSet getLed(TQColor col,bool state = true);

        TQIconSet getServerLed(bool state);
        TQIconSet getSystemLed(bool state);
        TQIconSet getMsgsLed(bool state);
        TQIconSet getPrivateLed(bool state);
        TQIconSet getEventsLed();
        TQIconSet getNickLed();
        TQIconSet getHighlightsLed();

        TQIconSet getKimproxyAway() const;
        TQIconSet getKimproxyOnline() const;
        TQIconSet getKimproxyOffline() const;

        TQPixmap getNickIcon(NickPrivilege privilege,bool isAway=false) const;
        void initializeNickIcons();

    public slots:
        void updateIcons();

    protected:
        void initializeLeds();
        void initializeKimifaceIcons();

        TQPixmap m_closeIcon;
        TQPixmap m_disabledCloseIcon;

        TQIconSet m_serverLedOn;
        TQIconSet m_serverLedOff;
        TQIconSet m_systemLedOn;
        TQIconSet m_systemLedOff;
        TQIconSet m_msgsLedOn;
        TQIconSet m_msgsLedOff;
        TQIconSet m_privateLedOn;
        TQIconSet m_privateLedOff;
        TQIconSet m_eventsLedOn;
        TQIconSet m_nickLedOn;
        TQIconSet m_highlightsLedOn;

        TQColor m_serverColor;
        TQColor m_systemColor;
        TQColor m_msgsColor;
        TQColor m_privateColor;
        TQColor m_eventsColor;
        TQColor m_nickColor;
        TQColor m_highlightsColor;

        TQIconSet kimproxyAway;
        TQIconSet kimproxyOnline;
        TQIconSet kimproxyOffline;

                                                  // [privilege][away]
        TQPixmap nickIcons[_NickPrivilege_COUNT][2];
};
#endif
