/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  copyright: (C) 2004 by Peter Simonsson
  email:     psn@linux.se
*/
#ifndef KONVERSATIONIDENTITYDIALOG_H
#define KONVERSATIONIDENTITYDIALOG_H

#include "identity.h"

#include <kdialogbase.h>


class KComboBox;
class KLineEdit;
class TQCheckBox;
class TQSpinBox;
class TQListBox;
class TQGroupBox;
class TQToolButton;

namespace Konversation
{

    class IdentityDialog : public KDialogBase
    {
        Q_OBJECT
        public:
            explicit IdentityDialog(TQWidget *parent = 0, const char *name = 0);
            ~IdentityDialog();
            void setCurrentIdentity(int index);
            IdentityPtr setCurrentIdentity(IdentityPtr identity);
            IdentityPtr currentIdentity() const;


        signals:
            void identitiesChanged();


        protected slots:
            void updateIdentity(int index);

            void addNickname();
            void editNickname();
            void deleteNickname();
            void updateButtons();
            void moveNicknameUp();
            void moveNicknameDown();

            void refreshCurrentIdentity();

            void slotOk();

            void newIdentity();
            void renameIdentity();
            void deleteIdentity();
            void copyIdentity();


        private:
            KComboBox* m_identityCBox;
            KLineEdit* m_realNameEdit;
            KLineEdit* m_sCommandEdit;
            KLineEdit* m_loginEdit;
            KComboBox* m_codecCBox;
            KLineEdit* m_botEdit;
            KLineEdit* m_passwordEdit;
            KLineEdit* m_quitEdit;
            KLineEdit* m_partEdit;
            KLineEdit* m_kickEdit;
            KLineEdit* m_awayEdit;
            KLineEdit* m_unAwayEdit;
            KLineEdit* m_awayNickEdit;
            TQCheckBox* m_insertRememberLineOnAwayChBox;
            TQListBox* m_nicknameLBox;
            TQGroupBox* m_awayMessageGBox;
            TQGroupBox* m_automaticAwayGBox;
            TQSpinBox* m_awayInactivitySpin;
            TQCheckBox* m_automaticUnawayChBox;
            TQToolButton* m_editBtn;
            TQToolButton* m_delBtn;
            TQToolButton* m_upNicknameBtn;
            TQToolButton* m_downNicknameBtn;
            TQPushButton* m_addNicknameBtn;
            TQPushButton* m_changeNicknameBtn;
            TQPushButton* m_removeNicknameBtn;

            IdentityList m_identityList;
            IdentityPtr m_currentIdentity;
    };

}
#endif
