/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  This class holds the various user identities
  begin:     Son Feb 9 2003
  copyright: (C) 2003 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/

#ifndef IDENTITY_H
#define IDENTITY_H

#include <ksharedptr.h>
#include <tqstringlist.h>


class TQTextCodec;

class Identity : public KShared
{
    public:
        /// Create an Identity with a new id.
        Identity();
        /// Create a new Identity with a set id.
        explicit Identity(int id);
        /// Copy all of @param original including the id.
        Identity(const Identity& original);
        ~Identity();

        /// This function copies all of @param original but the id
        void copy(const Identity& original);

        void setName(const TQString& name);        // the name of this identity
        TQString getName() const;

        void setRealName(const TQString& name);
        TQString getRealName() const;
        void setIdent(const TQString& ident);
        TQString getIdent() const;

        void setNickname(uint index,const TQString& nick);
        TQString getNickname(uint index) const;

        void setBot(const TQString& bot);
        TQString getBot() const;
        void setPassword(const TQString& password);
        TQString getPassword() const;

        void setNicknameList(const TQStringList& newList);
        TQStringList getNicknameList() const;

        void setQuitReason(const TQString& reason);
        TQString getQuitReason() const;
        void setPartReason(const TQString& reason);
        TQString getPartReason() const;
        void setKickReason(const TQString& reason);
        TQString getKickReason() const;

        void setInsertRememberLineOnAway(bool state);
        bool getInsertRememberLineOnAway() const;
        void setShowAwayMessage(bool state);
        bool getShowAwayMessage() const;

        void setAwayMessage(const TQString& message);
        TQString getAwayMessage() const;
        void setReturnMessage(const TQString& message);
        TQString getReturnMessage() const;

        void setAutomaticAway(bool automaticAway);
        bool getAutomaticAway() const;
        void setAwayInactivity(int awayInactivity);
        int getAwayInactivity() const;
        void setAutomaticUnaway(bool automaticUnaway);
        bool getAutomaticUnaway() const;

        void setShellCommand(const TQString &command);
        TQString getShellCommand() const;

        void setCodecName(const TQString &newCodecName);
        TQString getCodecName() const;
        TQTextCodec* getCodec() const;

        TQString getAwayNick() const;
        void setAwayNick(const TQString& n);

        int id() const { return m_id; }

    protected:
        TQString name;

        TQString bot;
        TQString password;

        TQString realName;
        TQString ident;

        TQStringList nicknameList;

        TQString partReason;
        TQString quitReason;
        TQString kickReason;

        bool insertRememberLineOnAway;
        bool showAwayMessages;
        TQString awayMessage;
        TQString returnMessage;

        bool m_automaticAway;
        int m_awayInactivity;
        bool m_automaticUnaway;

        TQString m_codecName;
        TQTextCodec* m_codec;

        TQString m_shellCommand;

        TQString awayNick;

    private:
        int m_id;
        static int s_availableId;
        void init();
};

typedef KSharedPtr<Identity> IdentityPtr;
typedef TQValueList<IdentityPtr> IdentityList;

#endif
