/*
  send a file on DCC protocol
  begin:     Mit Aug 7 2002
  copyright: (C) 2002 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/
// Copyright (C) 2004-2007 Shintaro Matsuoka <shin@shoegazed.org>
// Copyright (C) 2004,2005 John Tapsell <john@geola.co.uk>

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

#ifndef DCCTRANSFERSEND_H
#define DCCTRANSFERSEND_H

#include "dcctransfer.h"

#include <tqfile.h>


class TQTimer;

namespace KNetwork
{
    class KServerSocket;
    class KStreamSocket;
}

class DccTransferSend : public DccTransfer
{
    Q_OBJECT

        public:
        DccTransferSend(TQObject* parent);
        virtual ~DccTransferSend();

        // REQUIRED
        void setFileURL( const KURL& url );
        // OPTIONAL
        void setFileName( const TQString& fileName );
        // REQUIED
        // FIXME: this setting should be an optional one or be removed: make DccTransferSend itself read the configuration
        void setOwnIp( const TQString& ownIp );
        // OPTIONAL
        void setFileSize( KIO::filesize_t fileSize );
        // OPTIONAL
        void setReverse( bool reverse );

        bool setResume( unsigned long position );

    public slots:
        virtual bool queue();
        virtual void start();
        virtual void abort();

        // invoked when the receiver accepts the offer (Reverse DCC)
        void connectToReceiver( const TQString& partnerHost, const TQString& partnerPort );

    protected slots:
        void acceptClient();
        // it must be invoked when m_sendSocket is ready
        void startSending();
        void writeData();
        void getAck();
        void slotGotSocketError( int errorCode );
        void slotConnectionTimeout();
        void slotConnectionFailed( int errorCode );
        void slotSendSocketClosed();
        void slotServerSocketClosed();

    protected:
        void cleanUp();
        void failed(const TQString& errorMessage = TQString() );

        void startConnectionTimer( int sec );
        void stopConnectionTimer();

        TQString getQFileErrorString( int code );

        TQFile m_file;

        /*The filename of the temporary file that we downloaded.  So if send a file ftp://somewhere/file.txt
         * Then this will be downloaded to /tmp.
         */
        TQString m_tmpFile;

        KNetwork::KServerSocket* m_serverSocket;
        KNetwork::KStreamSocket* m_sendSocket;
        bool m_fastSend;

        TQTimer* m_connectionTimer;
};

#endif  // DCCTRANSFERSEND_H
