/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2002 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2005 Ismail Donmez <ismail@kde.org>
  Copyright (C) 2005 Peter Simonsson <psn@linux.se>
  Copyright (C) 2005 John Tapsell <johnflux@gmail.com>
  Copyright (C) 2005-2008 Eike Hein <hein@kde.org>
*/

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include "servergroupsettings.h"
#include "identity.h"
#include "preferences_base.h"

#include <tqobject.h>
#include <tqptrlist.h>
#include <tqsize.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>
#include <tqfont.h>
#include <tqcolor.h>
#include <tqmap.h>

#include <kdeversion.h>


/*
Options still to be GUIfied:

Operator LEDs (int)
OperatorColor (int)
VoiceColor (int)
NoRightsColor (int)
*/

class Ignore;
class Highlight;

class Preferences : public TQObject, public PreferencesBase
{
    Q_OBJECT

    protected:
        Preferences();
        static Preferences *mSelf;

    public:

        static Preferences *self();
        ~Preferences();
        enum Pages
        {
            NotifyPage,
            ChatWinAppearancePage
        };
        static const Konversation::ServerGroupList serverGroupList();
        static void setServerGroupList(const Konversation::ServerGroupList& list);
        static void addServerGroup(Konversation::ServerGroupSettingsPtr serverGroup);
        static const Konversation::ServerGroupSettingsPtr serverGroupById(int id);
        static const Konversation::ServerGroupSettingsPtr serverGroupByServer(const TQString& server);
        static int serverGroupIdByName(const TQString& serverGroup);
        static bool isServerGroup(const TQString& server);
        static void removeServerGroup(int id);

        /** Returns a list of alias set up by default.  This is a set of aliases for the scripts found. */
        static TQStringList defaultAliasList();

        //notifylist is in kconfigxt - FIXME
        static const TQMap<int, TQStringList> notifyList();
        static const TQStringList notifyListByGroupName(const TQString& groupName);
        static const TQString notifyStringByGroupName(const TQString& groupName);
        static void setNotifyList(const TQMap<int, TQStringList>& newList);
        static bool addNotify(int serverGroupId, const TQString& newPattern);
        static bool removeNotify(const TQString& groupName, const TQString& pattern);
        static bool isNotify(int serverGroupId, const TQString& pattern);
        static bool hasNotifyList(int serverGroupId);

        static const TQPtrList<Highlight> highlightList();
        static void setHighlightList(TQPtrList<Highlight> newList);
        static void addHighlight(const TQString& newHighlight,bool regExp, const TQColor &color,const TQString& sound,const TQString& autoText);

        /* All of the below work on the first (default) identity in your identity list*/
        static void addIgnore(const TQString &newIgnore);
        static bool removeIgnore(const TQString &oldIgnore);
        static bool isIgnored(const TQString &nickname);
        static void clearIgnoreList();
        static const TQPtrList<Ignore> ignoreList();
        static void setIgnoreList(TQPtrList<Ignore> newList);

        static const TQStringList quickButtonList();
        static const TQStringList defaultQuickButtonList();
        static void setQuickButtonList(const TQStringList newList);
        static void clearQuickButtonList();

        static const TQStringList autoreplaceList();
        static const TQStringList defaultAutoreplaceList();
        static void setAutoreplaceList(const TQStringList newList);
        static void clearAutoreplaceList();

        static void addIdentity(IdentityPtr identity);
        static void removeIdentity(IdentityPtr identity);
        static void clearIdentityList();
        static const IdentityList identityList();
        static void setIdentityList(const IdentityList& list);
        static const IdentityPtr identityByName(const TQString& name);
        static const IdentityPtr identityById(int id);
        static const TQString ident();
        static void setIdent(const TQString &ident);
        static const TQString realName();
        static void setRealName(const TQString &name);
        static const TQString partReason();
        static void setPartReason(const TQString &newReason);
        static const TQString kickReason();
        static void setKickReason(const TQString &newReason);
        static void setShowAwayMessage(bool state);
        static bool showAwayMessage();
        static const TQString awayMessage();
        static void setAwayMessage(const TQString &newMessage);
        static const TQString unAwayMessage();
        static void setUnAwayMessage(const TQString &newMessage);
        static const TQString defaultNicknameSortingOrder();
        static const TQString nickname(int index);
        static const TQStringList nicknameList();
        static void setNickname(int index,const TQString &newName);
        static void setNicknameList(const TQStringList &newList);

        static bool dialogFlag(const TQString& flagName);
        static void setDialogFlag(const TQString& flagName,bool state);

        static const TQString channelEncoding(const TQString& server,const TQString& channel);
        static const TQString channelEncoding(int serverGroupId,const TQString& channel);
        static void setChannelEncoding(const TQString& server,const TQString& channel,const TQString& encoding);
        static void setChannelEncoding(int serverGroupId,const TQString& channel,const TQString& encoding);
        static const TQValueList<int> channelEncodingsServerGroupIdList();
        static const TQStringList channelEncodingsChannelList(int serverGroupId);

        static void setShowTrayIcon(bool state);
        static void setTrayNotify(bool state);
        static void setAutoUserhost(bool state);

        static TQString webBrowserCmd();

    signals:
        void requestServerConnection(int number);
        void requestSaveOptions();
        void autoContinuousWhoChanged();
        void updateTrayIcon();

    protected:
        IdentityPtr mIdentity;
        Konversation::ServerGroupList mServerGroupList;
        TQPtrList<Ignore> mIgnoreList;
        TQValueList<IdentityPtr> mIdentityList;
        TQPtrList<Highlight> mHighlightList;
        TQMap<int, TQStringList> mNotifyList;  // network id, list of nicks
        TQMap< int,TQMap<TQString,TQString> > mChannelEncodingsMap;  // mChannelEncodingsMap[serverGroupdId][channelName]
        TQStringList mQuickButtonList;
        TQStringList mAutoreplaceList;
        TQString mSortingOrder;
};
#endif
