
/***************************************************************************
 *                                                                         *
 *   KCPULoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __KCPULOAD_H
#define __KCPULOAD_H

#include "statpopup.h"

class KCPUProc;
class KToggleAction;

/**
 * The specific pop-up window used by KCPULoad.
 */
class KCPULoad : public StatPopup {
    Q_OBJECT

public:
    /**
     * Constructor and destructor.
     */
    KCPULoad(QWidget *parent = 0, const char *name = 0);
    ~KCPULoad();

public slots:
    /**
     * Slots for menu items.
     */
    void setSMP(bool);

protected:
    /**
     * Overrides from StatPopup.
     */
    virtual QString dockName(int which) const;
    virtual QColor defaultDockColor(int which) const;
    virtual void setupCustomActions();
    virtual void insertCustomItems(KPopupMenu* menu);
    virtual void takeReadingInternal();

private:
    /**
     * Changes the number of readings.
     */
    void resizeReadings(int n);

    /**
     * Reading raw CPU information.
     */
    KCPUProc* proc;
        /**< Used to obtain the raw information. */
    bool supportSMP;
        /**< Does this system support SMP at all? */

    /**
     * Actions.
     */
    KToggleAction* actSMP;
};

#endif
