#include "VButton.h"
#include <qvbox.h>
#include <qfont.h>

double VButton::pw=550.0;
double VButton::ph=235.0;

VButton::VButton(QWidget *parent, const char *name): QPushButton (parent,name)
{
	
	//connect(this,SIGNAL(clicked()),this,SLOT(sendKey()));
	setFocusPolicy(NoFocus);
	resize(30,30);
	press=false;

}
VButton::~VButton()
{

}
void VButton::shiftPressed(bool press)
{
	if (press==true){	
		QString tu=l.upper();
		if (tu.compare(l)==0){
			//QPushButton::setText(tu);
			QPushButton::setText(u);
		}
		else{
			QPushButton::setText(tu);
		}

	}
	else{
		QPushButton::setText(l);
	}
}
void VButton::capsPressed(bool press)
{
	if (press==true){	
		QString tu=l.upper();
		if (tu.compare(l)==0){
			QPushButton::setText(tu);
		}
		else{
			QPushButton::setText(u);
		}
	}
	else{
		QPushButton::setText(l);
	}
}

void VButton::setText(const QString& text)
{
	QPushButton::setText(text);
	l=text;
}
void VButton::setShiftText(const QString& text)
{
	u=text;
}

void VButton::setKeyCode(unsigned int keycode)
{
	this->keycode=keycode;
	
}
unsigned int VButton::getKeyCode()
{
	return this->keycode;
}
void VButton::sendKey()
{
	emit keyClick(keycode);
}

void VButton::reposition(int width, int height)
{
	double dx=pw/orig_size.x();
	double dy=ph/orig_size.y();
	double sdx=pw/orig_size.width();
	double sdy=ph/orig_size.height();
	move((int)(width/dx),(int)(height/dy));
	resize((int)(width/sdx), (int)(height/sdy));

}
void VButton::res()
{
	orig_size=geometry();
}

void VButton::mousePressEvent(QMouseEvent * e)
{
	press=true;
	QPushButton::mousePressEvent(e);
	sendKey();
	startTimer(500);
}

void VButton::mouseReleaseEvent(QMouseEvent * e)
{
	press=false;
	QPushButton::mouseReleaseEvent(e);
	killTimers();
	inrpt=false;                                                                        
}

void VButton::timerEvent(QTimerEvent *)
{
	if (!press){
		inrpt=false;
		return;
	}
	if (press && !inrpt) {
		inrpt=true;
		startTimer(120);
		return;
	}
	sendKey();
}
