

#ifndef REPLAYGAIN_H
#define REPLAYGAIN_H

#include <qobject.h>
#include <qstringlist.h>

class Config;
class Logger;
class KProcess;

/**
 * @short Starts a process to add/remove Replay Gain tags to/from a given file
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ReplayGain : public QObject
{
    Q_OBJECT
public:
    enum Mode {
        calc_track        = 0x0001,
        calc_album        = 0x0002,
        remove            = 0x0004,
        force             = 0x0008
    };

    /**
     * Constructor
     */
    ReplayGain( Config*, Logger* );

    /**
     * Destructor
     */
    virtual ~ReplayGain();

    /**
     * Add/remove Replay Gain
     * @param files a list of files (of the same format)
     * @param format the format of the file/files (extension or mime type)
     * @param prc a pointer to a KProcess
     * @param remove if true the Replay Gain tags are being removed, if false (default) the tags are calculated and added
     */
    bool apply( QStringList files, const QString& format, KProcess* proc, int logID, Mode mode = Mode(calc_track|calc_album) ); // NOTE const QStringList& ?

    /*
     * Returns the track and the album gain (in this order) of the @p file
     */
    //static QValueList<float> getReplayGain( QString file ); // obsolete

private:
    Config* config;
    Logger* logger;
};

#endif // REPLAYGAIN_H
