

#ifndef FORMATINFOLOADER_H
#define FORMATINFOLOADER_H

#include <qobject.h>
#include <qstringlist.h>
#include <qdom.h>

/**
 * @short The complete information about that format
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class FormatInfo
{
public:
    /**
     * Constructor
     */
    FormatInfo();

    /**
     * Destructor
     */
    virtual ~FormatInfo();

    QStringList mime_types;
    QStringList extensions;
    QString description;
    QStringList urls;
    enum CompressionType {
        lossy             = 0x0001, // encode with loss
        lossless          = 0x0002, // encode without loss
        hybrid            = 0x0004  // encode a file with loss and a correction file
    } compressionType;
    int size;
};

/**
 * @short The format info loader that provides information about the compression type and a format description
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class FormatInfoLoader : public QObject
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    FormatInfoLoader();

    /**
     * Destructor
     */
    virtual ~FormatInfoLoader();

    /** is this file a converter plugin and loadable? */
    bool verifyFile( QString );
    /** load a given file */
    FormatInfo* loadFile( QString );
    /** the dom tree for loading the xml file */
    QDomDocument domTree;
};

#endif // FORMATINFOLOADER_H
