/***************************************************************************
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef THEMEMOODIN_H
#define THEMEMOODIN_H

#include <qptrlist.h>

#include <kdebug.h>
#include <kpixmap.h>

#include <themeengine.h>
#include <objkstheme.h>

#include "scaler.h"
#include "cache.h"
#include "effectwidget.h"

typedef QPtrList<EffectWidget> EffectWidgetList;
typedef QValueList<QPoint> CoordsList;
typedef QValueList<QColor> ColorList;
typedef QValueList<QFont> FontList;
typedef QPtrList<QImage> ImageList;

class ThemeMoodin: public ThemeEngine
{
  Q_OBJECT

public:
  ThemeMoodin(QWidget *parent, const char *name, const QStringList& flags);

  inline const QString name() { return QString("Moodin"); }
  inline const int version() { return 0x042; }

  static QStringList names()
  {
    QStringList l;

    l << "Moodin";

    return l;
  };

  static QStringList statusPixmaps()
  {
    QStringList l;

    l << "filetypes"; // 1 filetypes
    l << "exec"; // 2 exec
    l << "key_bindings"; // 3 key_bindings
    l << "window_list"; // 4 window_list
    l << "desktop"; // 5 desktop
    l << "style"; // 6 style
    l << "kcmsystem"; // 7 kcmsystem
    l << "go"; // 8 go

    return l;
  };

public slots:
  void slotSetText(const QString& s);
  void slotSetPixmap(const QString&);

private:
  bool mUseIconSet;
  bool mLabelShadow;
  bool mShowStatusText;
  bool mAppendX;
  bool mUsersBackground;
  bool mTranslate;
  bool mLineUpImages;
  bool mKubuntuStyle;
  int mAnimationLength;
  int mAnimationDelay;
  int mIconSetSize;
  int mCurrentStatusIndex;
  int mImageSpacer;
  int mLabelCount;
  float mBeginOpacity;

  QString mCurrentAction;
  QString mBackgroundImage;
  QStringList mStatusIcons;
  QStringList mStatusMessages;
  QStringList mLabels;
  QColor mStatusColor;
  QColor mLabelShadowColor;
  QFont mStatusFont;
  QPoint mStatusCoords;
  QPoint mLabelShadowOffset;
  QWidget* mContainer;
  QSize mBaseResolution;
  QRect mSplashRect;

  KPixmap* mBG;

  Scaler* mScaler;
  Cache* mCache;

  EffectWidgetList mEffectWidgets;
  CoordsList mStatusIconCoords;
  CoordsList mStatusImageOffsets;
  CoordsList mLabelCoords;
  ColorList mLabelColors;
  FontList mLabelFonts;
  ImageList mImages;

  void init();
  void initBackground(QPainter* p);
  void initEffectWidgets();
  void initLabels(QPainter* p);

  void paintEvent(QPaintEvent* pe);
  void readSettings();
  void arrangeWidget(QWidget* me, const int index);
  void updateStatus();

  EffectWidget* createEffectWidget(QWidget *parent, QImage *image);
};

#endif
