/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <klocale.h>
//For compatibility with old versions of KDE
#include <kdeversion.h>

#include "ksystemlog.h"

//Include the right header, depending of the version of KDE
#if defined(KDE_MAKE_VERSION) && (KDE_VERSION >= KDE_MAKE_VERSION(3,4,0))
	#include "slotLogAction.h"
#else
	#include "slotLogActionCompatibility.h"
#endif

SlotLogAction::SlotLogAction(KSystemLog* p) :
	parent(p) {
	
}

#if defined(KDE_MAKE_VERSION) && (KDE_VERSION >= KDE_MAKE_VERSION(3,4,0))
void SlotLogAction::slotLogAction(KAction::ActivationReason reason, Qt::ButtonState state) {
	const QObject* sender=QObject::sender();
	
	//We can call the correct method from KSystemLog, which manage the two parameters
	parent->logActionClicked(sender, reason, state);
}
#else
void SlotLogAction::slotLogAction() {
	const QObject* sender=QObject::sender();
	
	//In the other case, We can only call the method from KSystemLog, which keeps compatibility
	parent->logActionClicked(sender);
}
#endif

//Include the right MOC file, depending of the version of KDE
#if defined(KDE_MAKE_VERSION) && (KDE_VERSION >= KDE_MAKE_VERSION(3,4,0))
	#include "slotLogAction.moc"
#else
	#include "slotLogActionCompatibility.moc"
#endif
