/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <kmessagebox.h>

#include "parsingHelper.h"
#include "sambaReader.h"

SambaReader::SambaReader(QObject *parent, const char *name) : 
	DefaultReader(parent, name)
	{
	
}


SambaReader::~SambaReader() {

}


void SambaReader::initColumns(LogViewColumns* columns) {
	columns->append(new LogViewColumn(i18n("Date"), true, false));
	columns->append(new LogViewColumn(i18n("Source File"), true, true));
	columns->append(new LogViewColumn(i18n("Function"), true, true));
	columns->append(new LogViewColumn(i18n("Line"), true, true));
	columns->append(new LogViewColumn(i18n("Message"), true, false));

}

LogLine* SambaReader::parseMessage(QString& logLine, LogFile* logFile) {

	/*
	 * Log line examples :
	 * [2005/06/27 21:06:01, 0] nmbd/nmbd.c:main(668)
	 * Netbios nameserver version 3.0.14a started.
	 * Copyright Andrew Tridgell and the Samba Team 1994-2004
	 * [2005/06/27 21:11:46, 0] nmbd/nmbd_become_lmb.c:become_local_master_stage2(396)
	 *  *****
	 *  Samba name server STEAKHACHE is now a local master browser for workgroup MAISON on subnet 192.168.1.33
	 * 
	 *  *****
	 * [2005/06/28 06:41:03, 0] nmbd/nmbd.c:terminate(56)
	 * Got SIGTERM: going down...
	 * [2005/06/28 18:08:11, 0] nmbd/nmbd.c:main(668)
	 * Netbios nameserver version 3.0.14a started.
	 * Copyright Andrew Tridgell and the Samba Team 1994-2004
	 */
	
	//The Date
	int dateBegin=logLine.find("[");
	int dateEnd=logLine.find("]");
	
	QString strDate=logLine.mid(dateBegin+1, dateEnd-dateBegin-1);
	
	QString year=strDate.mid(0, 4);
	QString month=strDate.mid(5, 2);
	QString day=strDate.mid(8, 2);
	
	QString hour=strDate.mid(11, 2);
	QString min=strDate.mid(14, 2);
	QString sec=strDate.mid(17, 2);

	QDate date=QDate(year.toInt(), month.toInt(), day.toInt());
	QTime time=QTime(hour.toInt(), min.toInt(), sec.toInt());

	logLine=logLine.remove(0, dateEnd+2);
	

	//The source file
	int doubleDot;
	doubleDot=logLine.find(":");
	QString file=logLine.left(doubleDot);
	logLine=logLine.remove(0, doubleDot+1);
	
	//The function
	int bracket=logLine.find("(");
	QString function=logLine.left(bracket);
	logLine=logLine.remove(0, bracket+1);
	
	//The line number
	bracket=logLine.find(")");
	QString lineNumber=logLine.left(bracket);
	
	//Remove the first return character and the two useless space of the first message line
	logLine=logLine.remove(0, bracket+4);

	//Message
	//Remove the last \n
	logLine=logLine.left(logLine.length()-1);
	//Remove return characters and 2 first spaces at each lines
	QString message=logLine.replace("\n  ", " / ");

	//QString message=logLine.replace("\n", " / ");
	
	QStringList list;
	list.push_back(file);
	list.push_back(function);
	list.push_back(lineNumber);
	list.push_back(message);
	
	QString filePath=logFile->url.path();

	LogLine* line=new LogLine(date, time, list, filePath, Globals::informationLogLevel, Globals::sambaMode->id);
	
	return(line);
}

QStringList* SambaReader::getRawBuffer(QFile* file) {
	kdDebug() << "Retrieving the raw buffer..." << endl;

	QString line;
	
	QString buffer;
	QString tmpBuffer;
	QStringList* rawBuffer=new QStringList();
	
	int res;

	//Insert the content of the file in a string list
	while(!file->atEnd()) {
	
		//Read the first MaxCharactersRead characters
		res=file->readLine(buffer, tmpMaxCharacters);
		
		//Ignore the rest of the line
		while(res==tmpMaxCharacters)
			file->readLine(tmpBuffer, tmpMaxCharacters);
		
		if (buffer[0]=='[') {
			
			//If it is not the first time we add a line
			if (!line.isNull()) {
				//Push the new buffer to the list
				rawBuffer->push_back(line);
			}
			
			line=buffer;
		}
		else {
			//line+='\n';
			line+=buffer;
		}
	}

	kdDebug() << "Raw buffer retrieved." << endl;
	
	return(rawBuffer);
}


#include "sambaReader.moc"
