/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <kdebug.h>

#include "parentLogLine.h"

ParentLogLine::ParentLogLine(
		QDate& date, QTime& time, QStringList& list, QString& file, LogLevel* level, int type,
		groupByType group, int column, LogViewColumns* cols) :
	
	LogLine(date, time, list, file, level, type),
	groupBy(group),
	groupByColumn(column),
	columns(cols) {
	
	
}

ParentLogLine::~ParentLogLine() {

}

groupByType ParentLogLine::getGroupBy() {
	return(groupBy);
}

int ParentLogLine::getGroupByColumn() {
	return(groupByColumn);
}

LogViewColumns* ParentLogLine::getColumns() {
	return(columns);
}

void ParentLogLine::addChild(LogLine* child) {
	children.append(child);
}

bool ParentLogLine::isParentLogLine() {
	return(true);
}

bool ParentLogLine::isChild(LogLine* child) {
	//Group by Log Level
	if (groupBy==GROUP_BY_LOG_LEVEL) {
		if (this->getLogLevel()==child->getLogLevel())
			return(true);
		else
			return(false);
	}
	//Group by Day
	else if (groupBy==GROUP_BY_DAY) {
		if (getTime().date()==child->getTime().date())
			return(true);
		else
			return(false);
	}
	//Group by Hour
	else if (groupBy==GROUP_BY_HOUR) {
		QTime parentTime=getTime().time();
		QTime childTime=child->getTime().time();
		
		if (getTime().date()==child->getTime().date() && parentTime.hour()==childTime.hour())
			return(true);
		else
			return(false);

	}
	//Group by Log File
	else if (groupBy==GROUP_BY_LOG_FILE) {
		if (getOriginalFile()==child->getOriginalFile())
			return(true);
		else
			return(false);
	}
	//Group by specific column
	else {
	
		int index=ParentLogLine::getGroupedColumnIndex(columns, getGroupByColumn());

		QStringList& list=getItemList();
		if (index<0 || index>=(int)list.size())
			return(false);
		else {
			if (list[index]==child->getItemList()[index])
				return(true);
			else
				return(false);
		}
	
	}
	
	
}

int ParentLogLine::getGroupedColumnIndex(LogViewColumns* columns, int column) {
	LogViewColumns::Iterator it = columns->begin();
	
	//If there is an error in the parameter
	if (column==-1) {
		kdDebug() << "Bad Grouped Index " << endl;
		return(-1);
	}
	
	int i=0;
	int found=0;
	bool ok=false;
	
	LogViewColumn* logColumn;
	while(it!=columns->end()) {
		logColumn=*it;
		if (logColumn->isFiltred==true) {
	
			if (found==column) {
				ok=true;
				break;
			}

			found++;
		}
		
		i++;
		it++;
	}

	if (ok==false) {
		kdDebug() << "Grouped Column Index Not found" << endl;
		return(-1);
	}
	else {
		//We substract 1 because of the Date column (always here!)
		return(i-1);
	}
	
}

void ParentLogLine::removeChild(LogLine* child) {
	children.remove(child);
}

bool ParentLogLine::hasChildren() {
	return(children.count()!=0);
}

