/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#ifndef OPTIONS_H
#define OPTIONS_H

#include <qframe.h>
#include <qspinbox.h>

#include <kconfig.h>
#include <kdialogbase.h>


#include "globals.h"

#include "generalOptions.h"

#include "systemOptions.h"
#include "kernelOptions.h"
#include "cronOptions.h"
#include "daemonOptions.h"

#include "xorgOptions.h"

#include "bootAuthenticationOptions.h"
#include "acpidOptions.h"
#include "cupsOptions.h"

#include "apacheOptions.h"
#include "postfixOptions.h"

class Options: public KDialogBase {
	Q_OBJECT
	
	public:
		Options(QWidget *parent, const char *name, bool modal);
	
		~Options();
	public slots:
		void saveConfig();
		
		void optionsChanged(bool valid);
		
		void disableApplyButton();

	private:
		GeneralOptions* generalOptions;
		SystemOptions* systemOptions;
		KernelOptions* kernelOptions;
		CronOptions* cronOptions;
		DaemonOptions* daemonOptions;
		
		XorgOptions* xorgOptions;
		
		BootAuthenticationOptions* bootAuthenticationOptions;
		
		AcpidOptions* acpidOptions;
		CupsOptions* cupsOptions;
		
		ApacheOptions* apacheOptions;
		PostfixOptions* postfixOptions;

		void setupGeneralOptions();
		void setupSystemOptions();
		void setupKernelOptions();
		void setupCronOptions();
		void setupDaemonOptions();
		
		void setupXorgOptions();
		
		void setupBootAuthenticationOptions();
		
		void setupAcpidOptions();
		void setupCupsOptions();
		
		void setupApacheOptions();
		
		void setupPostfixOptions();


};

#endif //OPTIONS_H
