/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "ksystemlog.h"

#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[]=I18N_NOOP("System Logs Viewer Tool for KDE");

static const char version[]="0.3.2";

static KCmdLineOptions options[] = {
	{ "+[URL]", I18N_NOOP( "Document to open" ), 0 },
	KCmdLineLastOption
};


int main(int argc, char **argv) {
	KAboutData about(	"ksystemlog", 
						I18N_NOOP("KSystemlog"), 
						version, 
						description,
						KAboutData::License_GPL, 
						"(C) 2005, Nicolas Ternisien", 
						0, 
						0, 
						"nicolas.ternisien@gmail.com"
	);
	
	about.addAuthor("Nicolas Ternisien", 0, "nicolas.ternisien@gmail.com" );
	
	about.addCredit("Patrick Decker", I18N_NOOP("Ideas, Code improvements" ), "patrick@decker.org" );
	//about.addCredit(I18N_NOOP("French trains between Paris and Rouen"), I18N_NOOP("Often late, so I have time to improve KSystemLog ;-)" ), "info@sncf.fr" );
	
	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions(options);
	KApplication app;
	
	//Register ourselves as a DCOP client
	app.dcopClient()->registerAs(app.name(), false);
	
	//See if we are starting with session management
	if (app.isRestored()) {
		RESTORE(KSystemLog);
	}
	else {
		//No session... Just start up normally
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		if (args->count() == 0) {
			KSystemLog *widget = new KSystemLog();
			widget->show();
		}
		else {
			int i = 0;
			for (; i < args->count(); i++) {
				KSystemLog *widget = new KSystemLog();
				widget->show();
				
				//Useless
				//widget->load(args->url(i));
			
			}
		}
		args->clear();
	}
	
	return(app.exec());
}
