/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef LOG_LIST_ITEM_H
#define LOG_LIST_ITEM_H

#include <qobject.h>
#include <qstringlist.h>
#include <qfile.h>
#include <qpixmap.h>
#include <qmap.h>
#include <qregexp.h>

#include <kiconloader.h>
#include <kurl.h>
#include <klistview.h>

#include "globals.h"

#include "logLine.h"


class LogLine;
class LogMode;
class XorgLogLine;



/**
 * @author Nicolas Ternisien
 */
class LogListItem : public KListViewItem {
	
	public:
		LogListItem(QListView* list, LogLine* l);
		
		LogListItem(QListViewItem* parent, LogLine* l);

		~LogListItem();
		
		QDateTime& getTime();
		
		virtual int compare(QListViewItem * i, int col, bool ascending) const;
		
		QString getFormattedText();
		QString getToolTipText();
		
		LogLine* getLogLine();
		
		virtual void paintCell(QPainter* p, const QColorGroup &cg, int column, int width, int align);
		
		QString exportToText();
		
	protected:
		LogLine* line;

};

#endif //LOG_LIST_ITEM_H
