/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "logLineTree.h"

#include "parentLogLine.h"
#include "childLogLine.h"
#include "logLine.h"

#include "view.h"


LogLineTree::LogLineTree(LogViewColumns* cols, groupByType type, int column) :
	LogLineList()
	{
	
	columns=cols;
	groupBy=type;
	groupByColumn=column;

}

LogLineTree::~LogLineTree() {

}


void LogLineTree::synchronizeRemovedLines(View* view) {
	QPtrListIterator<LogLine> it(removedList);
	
	LogLine* line=it.current();
	
	kdDebug() << "Removing old items from tree..." << endl;
	
	//We removed the old items
	while(line!=NULL) {
		if (line->itemExists()) {
			line->removeItem(view->getLogList());
		}
	
		//TODO Delete the line object
		
		++it;
		line=it.current();
	}
	
	removedList.clear();
	
}

LogLine* LogLineTree::synchronizeAddedLines(View* view) {

	/**
	 * This old code had to do the same thing than the above code, but
	 * it was buggy for a strange reason.
	 * This code wasn't able to find Parent Log Lines in the addedList object
	 */
	/*
	//We first add the new parent items
	QPtrListIterator<LogLine> it(addedList);
	
	LogLine* line=it.current();
	
	kdDebug() << "Inserting " << parents.count() << " parent log item" << endl;
	
	int i=0;
	while (line!=NULL) {
		if (line->isParentLogLine()==true) {
			ParentLogLine* parent=(ParentLogLine*) (line);
			parent->insertItem(view->getLogList());
			
			addedList.remove(it.current());
			++i;
		}
		
		++it;

		line=it.current();
	}
	
	kdDebug() << "Insertion of " << i << " parent log items" << endl;
	*/
	
	kdDebug() << "Adding parent items to the tree..." << endl;
	
	//We first add the new parent items
	QPtrListIterator<ParentLogLine> it(parents);
	
	LogLine* line=it.current();
		
	while (line!=NULL) {
		//Even if the parent has already been added, it will automatically be added once time
		line->insertItem(view->getLogList());
		
		addedList.remove(it.current());
		
		++it;
		line=it.current();
	}
	

	//Returns line, even if line is NULL (must be tested by the caller class)
	return(LogLineList::synchronizeAddedLines(view));
}

bool LogLineTree::remove(LogLine* line) {
	/**
	 * Parent log line actions : 
	 * - Only remove this line is it does not have any children left
	 */
	if (line->isParentLogLine()==true) {
		ParentLogLine* parent=(ParentLogLine*) line;
		
		if (parent->hasChildren()==false) {
			parents.remove(parent);
			return(LogLineList::remove(line));
		}

	}
	/**
	 * Child log line actions : 
	 * - First remove the dependency from the parent
	 * - Remove parent if it does not have child left
	 * - Finally remove child
	 */
	else if (line->isChildLogLine()==true) {
		ChildLogLine* child=(ChildLogLine*) line;
		ParentLogLine* parent=child->getParent();
		parent->removeChild(child);
		
		//Remove parent if it does not have longer children
		if (parent->hasChildren()==false) {
			parents.remove(parent);
			LogLineList::remove(parent);
		}
		
		//Remove the children
		return(LogLineList::remove(line));
		
	}
	
	//Default case, with normal log lines
	return(LogLineList::remove(line));
	
}

void LogLineTree::insert(LogLine* line) {
	
	QPtrListIterator<ParentLogLine> it(parents);
	ParentLogLine* parent=it.current();
	
	bool insertion=false;
	
	while (parent!=NULL) {
		insertion=parent->isChild(line);
		if (insertion==true) {

			QDate date=line->getTime().date();
			QTime time=line->getTime().time();
			
			ChildLogLine* newChild=new ChildLogLine(date, time, line->getItemList(), line->getOriginalFile(), line->getLogLevel(), line->getType());
			
			parent->addChild(newChild);
			newChild->setParent(parent);
			
			//Insert this child by the classical way
			LogLineList::insert(newChild);
			
			delete line;
			
			return;
		}
		
		++it;
		parent=it.current();
	}
	
	QDate date=line->getTime().date();
	QTime time=line->getTime().time();
	
	ParentLogLine* newParent=new ParentLogLine(date, time, line->getItemList(), line->getOriginalFile(), line->getLogLevel(), line->getType(), this->groupBy, this->groupByColumn, this->columns);
	//Insert this parent by the classical way
	LogLineList::insert(newParent);
	
	parents.append(newParent);
	
	ChildLogLine* newChild=new ChildLogLine(date, time, line->getItemList(), line->getOriginalFile(), line->getLogLevel(), line->getType());
	newParent->addChild(newChild);
	newChild->setParent(newParent);
	//Insert this child by the classical way
	LogLineList::insert(newChild);
	
	delete line;


}
