/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _LOG_LINE_LIST_H_
#define _LOG_LINE_LIST_H_

#include <qobject.h>
#include <qptrlist.h>
#include <qmap.h>

#include <kdebug.h>

#include "globals.h"
#include "qlistview.h"
#include "logLine.h"

class View;

/**
 * @author Nicolas Ternisien
 */
class LogLineList {
	
	public:
		LogLineList();
		
		virtual ~LogLineList();
		
		/**
		 * Synchronize the view with this buffer and returns the last added item
		 */
		virtual LogLine* synchronize(View* view);
		


		LogLine* getOldestLine();

		int getItemCount();
		
		void clear();
		
		bool isEmpty();
		
		void removeOldestLine();
		
		virtual bool remove(LogLine* line);
		virtual void insert(LogLine* line);
		
		//Can also returns NULL
		LogLine* lastLineInserted();
	
		bool equals(LogLine* l1, LogLine* l2);
		
		bool lineAlreadyExists(LogLine* line);

		bool isNewer(LogLine* line);
	
		int getNewLineCount();
		
		void setFirstReadPerformed(bool add);
		
	protected:
		/**
		 * Synchronize the old recent lines, then the new ones
		 */
		virtual void synchronizeRecentLines();
		
		/**
		 * Synchronize the lines to delete
		 */
		virtual void synchronizeRemovedLines(View* view);
		
		/**
		 * Synchronize new lines and returns the last one
		 */
		virtual LogLine* synchronizeAddedLines(View* view);
	
	
	
		void updateOldestLine();

		QPtrList<LogLine> list;
		
		QPtrList<LogLine> addedList;
		
		QPtrList<LogLine> removedList;

		QPtrList<LogLine> recentList;
		
		LogLine* oldestLogLine;
		
		bool firstAdd;

};

#endif
