/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//For compatibility with old versions of KDE
#include <kdeversion.h>

//The filter is activated only if KDE version >= 3.3
#if defined(KDE_MAKE_VERSION) && KDE_VERSION >= KDE_MAKE_VERSION(3,3,0)

#include <qpainter.h>

#include <klocale.h>

#include "logLineFilter.h"

LogLineFilter::LogLineFilter(QWidget* parent, KListView* listView, const char* name) :
	KListViewSearchLine(parent, listView, name) {

	drawFilterMessage = true;
	
	repaint();
}


void LogLineFilter::drawContents(QPainter *p) {
    KListViewSearchLine::drawContents( p );

    if ( drawFilterMessage == true && !hasFocus() ) {
        QPen tmp = p->pen();
        p->setPen( palette().color( QPalette::Disabled, QColorGroup::Text ) );
        QRect cr = contentsRect();

        //p->drawPixmap( 3, 3, SmallIcon("filter") );

        // Add two pixel margin on the left side
        cr.rLeft() += 3;
        p->drawText( cr, AlignAuto | AlignVCenter, i18n("Filter here...") );
        p->setPen( tmp );
    }
}


void LogLineFilter::focusInEvent( QFocusEvent *ev )
{
    if ( drawFilterMessage == true ) {
        drawFilterMessage = false;
        repaint();
    }
    KListViewSearchLine::focusInEvent( ev );
}


void LogLineFilter::focusOutEvent( QFocusEvent *ev )
{
    if ( text().isEmpty() ) {
        drawFilterMessage = true;
        repaint();
    }
    KListViewSearchLine::focusOutEvent( ev );
}


#endif
