/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//KDE includes
#include <kdebug.h>

//Project includes
#include "itemFactory.h"

#include "logLine.h"


LogLine::LogLine(QDate& date, QTime& time, QStringList& list, QString& file, LogLevel* level, int type) :
	time(date, time),
	itemList(list),
	originalFile(file),
	logLevel(level),
	type(type),
	recent(false),
	item(NULL) {
	
}

LogLine::~LogLine() {
	if (item!=NULL)
		delete item;
}

int LogLine::getType() {
	return(type);
}

void LogLine::setType(int t) {
	type=t;
}

bool LogLine::itemExists() {
	if (item==NULL)
		return(false);
	else
		return(true);
}

void LogLine::setRecent(bool recent) {
	this->recent=recent;
	if (item!=NULL) {
		//TODO This is certainly the main problem of the unknown crash bug !
		//item->repaint();
	}
}

bool LogLine::isRecent() {
	return(recent);
}

LogListItem* LogLine::getLogListItem() {
	return(item);
}

LogListItem* LogLine::insertItem(QListView* view) {
	if (item==NULL) {
		item=ItemFactory::createLogListItem(view, this);
	}
	
	return(item);
}

bool LogLine::equals(LogLine& other) {
	if (getType() != other.getType())
		return(false);
	
	if (getTime() != other.getTime())
		return(false);
	
	if (getLogLevel() != other.getLogLevel())
		return(false);

	/*
	if (getOriginalFile() != other.getOriginalFile())
		return(false);
	*/
	
	if (getItemList() != other.getItemList())
		return(false);
	
	return(true);
}

void LogLine::removeItem(QListView* view) {
	if (item==NULL)
		return;
		
	view->takeItem(item);

}

LogLevel* LogLine::getLogLevel() {
	return(logLevel);	
}

void LogLine::setLogLevel(LogLevel* level) {
	logLevel=level;
}

QDateTime& LogLine::getTime() {
	return(time);
}

QStringList& LogLine::getItemList() {
	return(itemList);
}

QString& LogLine::getOriginalFile() {
	return(originalFile);
}

bool LogLine::isOlderThan(LogLine& other) {
	return(time<=other.getTime());
}

bool LogLine::isNewerThan(LogLine& other) {
	return(time>=other.getTime());
}

bool LogLine::isOlderThan(QDateTime& other) {
	return(time<=other);
}

bool LogLine::isNewerThan(QDateTime& other) {
	return(time>=other);
}


bool LogLine::isSameTime(LogLine& other) {
	return(time==other.getTime());
}

bool LogLine::operator<(LogLine& other) {
	return(isOlderThan(other));
}

bool LogLine::operator>(LogLine& other) {
	return(isNewerThan(other));
}

void LogLine::ensureItemVisible(QListView* view) {
	if (item!=NULL)
		view->ensureItemVisible(item);
}

bool LogLine::isParentLogLine() {
	return(false);
}

bool LogLine::isChildLogLine() {
	return(false);
}

